/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.jdk8;

import java.util.Objects;
import org.threeten.bp.LocalTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.jdk8.DefaultInterfaceTemporal;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.ChronoLocalDateTime;
import org.threeten.bp.temporal.Era;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAdder;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.TemporalSubtractor;
import org.threeten.bp.temporal.TemporalUnit;

public abstract class DefaultInterfaceChronoLocalDate<C extends Chrono<C>>
extends DefaultInterfaceTemporal
implements ChronoLocalDate<C> {
    @Override
    public Era<C> getEra() {
        return ((Chrono)this.getChrono()).eraOf(this.get(ChronoField.ERA));
    }

    @Override
    public boolean isLeapYear() {
        return ((Chrono)this.getChrono()).isLeapYear(this.getLong(ChronoField.YEAR));
    }

    @Override
    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return ((ChronoField)field).isDateField();
        }
        return field != null && field.doIsSupported(this);
    }

    @Override
    public ChronoLocalDate<C> with(TemporalAdjuster adjuster) {
        return ((Chrono)this.getChrono()).ensureChronoLocalDate(super.with(adjuster));
    }

    @Override
    public ChronoLocalDate<C> plus(TemporalAdder adjuster) {
        return ((Chrono)this.getChrono()).ensureChronoLocalDate(super.plus(adjuster));
    }

    @Override
    public ChronoLocalDate<C> minus(TemporalSubtractor adjuster) {
        return ((Chrono)this.getChrono()).ensureChronoLocalDate(super.minus(adjuster));
    }

    @Override
    public ChronoLocalDate<C> minus(long amountToSubtract, TemporalUnit unit) {
        return ((Chrono)this.getChrono()).ensureChronoLocalDate(super.minus(amountToSubtract, unit));
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toEpochDay());
    }

    @Override
    public ChronoLocalDateTime<C> atTime(LocalTime localTime) {
        return Chrono.dateTime(this, localTime);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chrono()) {
            return (R)this.getChrono();
        }
        return super.query(query);
    }

    @Override
    public long toEpochDay() {
        return this.getLong(ChronoField.EPOCH_DAY);
    }

    @Override
    public int compareTo(ChronoLocalDate<?> other) {
        int cmp = Long.compare(this.toEpochDay(), other.toEpochDay());
        if (cmp == 0) {
            cmp = ((Chrono)this.getChrono()).compareTo((Chrono<?>)other.getChrono());
        }
        return cmp;
    }

    @Override
    public boolean isAfter(ChronoLocalDate<?> other) {
        return this.toEpochDay() > other.toEpochDay();
    }

    @Override
    public boolean isBefore(ChronoLocalDate<?> other) {
        return this.toEpochDay() < other.toEpochDay();
    }

    @Override
    public boolean isEqual(ChronoLocalDate<?> other) {
        return this.toEpochDay() == other.toEpochDay();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChronoLocalDate) {
            return this.compareTo((ChronoLocalDate)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long epDay = this.toEpochDay();
        return ((Chrono)this.getChrono()).hashCode() ^ (int)(epDay ^ epDay >>> 32);
    }

    @Override
    public String toString() {
        long yoe = this.getLong(ChronoField.YEAR_OF_ERA);
        long moy = this.getLong(ChronoField.MONTH_OF_YEAR);
        long dom = this.getLong(ChronoField.DAY_OF_MONTH);
        StringBuilder buf = new StringBuilder(30);
        buf.append(((Chrono)this.getChrono()).toString()).append(" ").append(this.getEra()).append(" ").append(yoe).append(moy < 10L ? "-0" : "-").append(moy).append(dom < 10L ? "-0" : "-").append(dom);
        return buf.toString();
    }

    @Override
    public String toString(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.print(this);
    }
}

