/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.zone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.threeten.bp.zone.ZoneRules;
import org.threeten.bp.zone.ZoneRulesException;

public abstract class ZoneRulesProvider {
    private static final CopyOnWriteArrayList<ZoneRulesProvider> PROVIDERS = new CopyOnWriteArrayList();
    private static final ConcurrentMap<String, ZoneRulesProvider> ZONES = new ConcurrentHashMap<String, ZoneRulesProvider>(512, 0.75f, 2);

    public static Set<String> getAvailableZoneIds() {
        return new HashSet<String>(ZONES.keySet());
    }

    public static ZoneRules getRules(String zoneId) {
        Objects.requireNonNull(zoneId, "zoneId");
        return ZoneRulesProvider.getProvider(zoneId).provideRules(zoneId);
    }

    public static NavigableMap<String, ZoneRules> getVersions(String zoneId) {
        Objects.requireNonNull(zoneId, "zoneId");
        return ZoneRulesProvider.getProvider(zoneId).provideVersions(zoneId);
    }

    private static ZoneRulesProvider getProvider(String zoneId) {
        ZoneRulesProvider provider = (ZoneRulesProvider)ZONES.get(zoneId);
        if (provider == null) {
            if (ZONES.isEmpty()) {
                throw new ZoneRulesException("No time-zone data files registered");
            }
            throw new ZoneRulesException("Unknown time-zone ID: " + zoneId);
        }
        return provider;
    }

    public static void registerProvider(ZoneRulesProvider provider) {
        Objects.requireNonNull(provider, "provider");
        ZoneRulesProvider.registerProvider0(provider);
        PROVIDERS.add(provider);
    }

    private static void registerProvider0(ZoneRulesProvider provider) {
        for (String zoneId : provider.provideZoneIds()) {
            Objects.requireNonNull(zoneId, "zoneId");
            ZoneRulesProvider old = ZONES.putIfAbsent(zoneId, provider.provideBind(zoneId));
            if (old == null) continue;
            throw new ZoneRulesException("Unable to register zone as one already registered with that ID: " + zoneId + ", currently loading from provider: " + provider);
        }
    }

    public static boolean refresh() {
        boolean changed = false;
        for (ZoneRulesProvider provider : PROVIDERS) {
            changed |= provider.provideRefresh();
        }
        return changed;
    }

    protected ZoneRulesProvider() {
    }

    protected abstract Set<String> provideZoneIds();

    protected ZoneRulesProvider provideBind(String zoneId) {
        return new BoundProvider(this, zoneId);
    }

    protected abstract ZoneRules provideRules(String var1);

    protected abstract NavigableMap<String, ZoneRules> provideVersions(String var1);

    protected boolean provideRefresh() {
        return false;
    }

    static {
        ServiceLoader<ZoneRulesProvider> sl = ServiceLoader.load(ZoneRulesProvider.class, ZoneRulesProvider.class.getClassLoader());
        ArrayList loaded = new ArrayList();
        Iterator<ZoneRulesProvider> it = sl.iterator();
        while (it.hasNext()) {
            ZoneRulesProvider provider;
            try {
                provider = it.next();
            }
            catch (ServiceConfigurationError ex) {
                if (ex.getCause() instanceof SecurityException) continue;
                throw ex;
            }
            ZoneRulesProvider.registerProvider0(provider);
        }
        PROVIDERS.addAll(loaded);
    }

    private static class BoundProvider
    extends ZoneRulesProvider {
        private final ZoneRulesProvider provider;
        private final String zoneId;
        private final ZoneRules rules;

        private BoundProvider(ZoneRulesProvider provider, String zoneId) {
            this.provider = provider;
            this.zoneId = zoneId;
            this.rules = provider.provideRules(zoneId);
        }

        @Override
        protected Set<String> provideZoneIds() {
            return new HashSet<String>(Collections.singleton(this.zoneId));
        }

        @Override
        protected ZoneRules provideRules(String regionId) {
            return this.rules;
        }

        @Override
        protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
            return this.provider.provideVersions(zoneId);
        }

        public String toString() {
            return this.zoneId;
        }
    }
}

