/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiConfiguration;
import org.tikv.common.operation.ErrorHandler;
import org.tikv.common.policy.RetryMaxMs;
import org.tikv.common.streaming.StreamingResponse;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ChannelFactory;
import shade.io.grpc.MethodDescriptor;
import shade.io.grpc.stub.AbstractStub;
import shade.io.grpc.stub.ClientCalls;
import shade.io.grpc.stub.StreamObserver;

public abstract class AbstractGRPCClient<BlockingStubT extends AbstractStub<BlockingStubT>, StubT extends AbstractStub<StubT>>
implements AutoCloseable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ChannelFactory channelFactory;
    protected TiConfiguration conf;
    protected BlockingStubT blockingStub;
    protected StubT asyncStub;

    protected AbstractGRPCClient(TiConfiguration conf, ChannelFactory channelFactory) {
        this.conf = conf;
        this.channelFactory = channelFactory;
    }

    protected AbstractGRPCClient(TiConfiguration conf, ChannelFactory channelFactory, BlockingStubT blockingStub, StubT asyncStub) {
        this.conf = conf;
        this.channelFactory = channelFactory;
        this.blockingStub = blockingStub;
        this.asyncStub = asyncStub;
    }

    public TiConfiguration getConf() {
        return this.conf;
    }

    public <ReqT, RespT> RespT callWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, Supplier<ReqT> requestFactory, ErrorHandler<RespT> handler) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Calling %s...", method.getFullMethodName()));
        }
        RetryMaxMs.Builder<RespT> builder = new RetryMaxMs.Builder<RespT>(backOffer);
        Object resp = builder.create(handler).callWithRetry(() -> {
            BlockingStubT stub = this.getBlockingStub();
            return ClientCalls.blockingUnaryCall(((AbstractStub)stub).getChannel(), method, ((AbstractStub)stub).getCallOptions(), requestFactory.get());
        }, method.getFullMethodName());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("leaving %s...", method.getFullMethodName()));
        }
        return (RespT)resp;
    }

    protected <ReqT, RespT> void callAsyncWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, Supplier<ReqT> requestFactory, StreamObserver<RespT> responseObserver, ErrorHandler<RespT> handler) {
        this.logger.debug(String.format("Calling %s...", method.getFullMethodName()));
        RetryMaxMs.Builder<RespT> builder = new RetryMaxMs.Builder<RespT>(backOffer);
        builder.create(handler).callWithRetry(() -> {
            StubT stub = this.getAsyncStub();
            ClientCalls.asyncUnaryCall(((AbstractStub)stub).getChannel().newCall(method, ((AbstractStub)stub).getCallOptions()), requestFactory.get(), responseObserver);
            return null;
        }, method.getFullMethodName());
        this.logger.debug(String.format("leaving %s...", method.getFullMethodName()));
    }

    <ReqT, RespT> StreamObserver<ReqT> callBidiStreamingWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, StreamObserver<RespT> responseObserver, ErrorHandler<StreamObserver<ReqT>> handler) {
        this.logger.debug(String.format("Calling %s...", method.getFullMethodName()));
        RetryMaxMs.Builder<StreamObserver<ReqT>> builder = new RetryMaxMs.Builder<StreamObserver<ReqT>>(backOffer);
        StreamObserver observer = builder.create(handler).callWithRetry(() -> {
            StubT stub = this.getAsyncStub();
            return ClientCalls.asyncBidiStreamingCall(((AbstractStub)stub).getChannel().newCall(method, ((AbstractStub)stub).getCallOptions()), responseObserver);
        }, method.getFullMethodName());
        this.logger.debug(String.format("leaving %s...", method.getFullMethodName()));
        return observer;
    }

    public <ReqT, RespT> StreamingResponse callServerStreamingWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, Supplier<ReqT> requestFactory, ErrorHandler<StreamingResponse> handler) {
        this.logger.debug(String.format("Calling %s...", method.getFullMethodName()));
        RetryMaxMs.Builder<StreamingResponse> builder = new RetryMaxMs.Builder<StreamingResponse>(backOffer);
        StreamingResponse response = builder.create(handler).callWithRetry(() -> {
            BlockingStubT stub = this.getBlockingStub();
            return new StreamingResponse(ClientCalls.blockingServerStreamingCall(((AbstractStub)stub).getChannel(), method, ((AbstractStub)stub).getCallOptions(), requestFactory.get()));
        }, method.getFullMethodName());
        this.logger.debug(String.format("leaving %s...", method.getFullMethodName()));
        return response;
    }

    protected abstract BlockingStubT getBlockingStub();

    protected abstract StubT getAsyncStub();
}

