/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.tikv.common.pd.PDUtils;
import org.tikv.kvproto.Kvrpcpb;

public class TiConfiguration
implements Serializable {
    private static final int DEF_TIMEOUT = 10;
    private static final TimeUnit DEF_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private static final int DEF_SCAN_BATCH_SIZE = 100;
    private static final boolean DEF_IGNORE_TRUNCATE = true;
    private static final boolean DEF_TRUNCATE_AS_WARNING = false;
    private static final int DEF_MAX_FRAME_SIZE = 0x20000000;
    private static final int DEF_INDEX_SCAN_BATCH_SIZE = 20000;
    private static final int DEF_REGION_SCAN_DOWNGRADE_THRESHOLD = 10000000;
    private static final int MAX_REQUEST_KEY_RANGE_SIZE = 20000;
    private static final int DEF_INDEX_SCAN_CONCURRENCY = 5;
    private static final int DEF_TABLE_SCAN_CONCURRENCY = 512;
    private static final Kvrpcpb.CommandPri DEF_COMMAND_PRIORITY = Kvrpcpb.CommandPri.Low;
    private static final Kvrpcpb.IsolationLevel DEF_ISOLATION_LEVEL = Kvrpcpb.IsolationLevel.SI;
    private static final boolean DEF_SHOW_ROWID = false;
    private static final String DEF_DB_PREFIX = "";
    private static final boolean DEF_WRITE_ENABLE = true;
    private static final boolean DEF_WRITE_ALLOW_SPARK_SQL = false;
    private static final boolean DEF_WRITE_WITHOUT_LOCK_TABLE = false;
    private static final int DEF_TIKV_REGION_SPLIT_SIZE_IN_MB = 96;
    private static final int DEF_PARTITION_PER_SPLIT = 1;
    private static final int DEF_KV_CLIENT_CONCURRENCY = 10;
    private static final KVMode DEF_KV_MODE = KVMode.TXN;
    private static final int DEF_RAW_CLIENT_CONCURRENCY = 200;
    private static final boolean DEF_IS_REPLICA_READ = false;
    private int timeout = 10;
    private TimeUnit timeoutUnit = DEF_TIMEOUT_UNIT;
    private boolean ignoreTruncate = true;
    private boolean truncateAsWarning = false;
    private int maxFrameSize = 0x20000000;
    private List<URI> pdAddrs = new ArrayList<URI>();
    private int indexScanBatchSize = 20000;
    private int downgradeThreshold = 10000000;
    private int indexScanConcurrency = 5;
    private int tableScanConcurrency = 512;
    private Kvrpcpb.CommandPri commandPriority = DEF_COMMAND_PRIORITY;
    private Kvrpcpb.IsolationLevel isolationLevel = DEF_ISOLATION_LEVEL;
    private int maxRequestKeyRangeSize = 20000;
    private boolean showRowId = false;
    private String dbPrefix = "";
    private KVMode kvMode = DEF_KV_MODE;
    private int rawClientConcurrency = 200;
    private boolean writeAllowSparkSQL = false;
    private boolean writeEnable = true;
    private boolean writeWithoutLockTable = false;
    private int tikvRegionSplitSizeInMB = 96;
    private int partitionPerSplit = 1;
    private int kvClientConcurrency = 10;
    private boolean isReplicaRead = false;

    public static TiConfiguration createDefault(String pdAddrsStr) {
        Objects.requireNonNull(pdAddrsStr, "pdAddrsStr is null");
        TiConfiguration conf = new TiConfiguration();
        conf.pdAddrs = TiConfiguration.strToURI(pdAddrsStr);
        return conf;
    }

    public static TiConfiguration createRawDefault(String pdAddrsStr) {
        Objects.requireNonNull(pdAddrsStr, "pdAddrsStr is null");
        TiConfiguration conf = new TiConfiguration();
        conf.pdAddrs = TiConfiguration.strToURI(pdAddrsStr);
        conf.kvMode = KVMode.RAW;
        return conf;
    }

    private static List<URI> strToURI(String addressStr) {
        Objects.requireNonNull(addressStr);
        Object[] addrs = addressStr.split(",");
        Arrays.sort(addrs);
        return PDUtils.addrsToUrls((String[])addrs);
    }

    public static <E> String listToString(List<E> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i).toString());
            if (i == list.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public TiConfiguration setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public TiConfiguration setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    public List<URI> getPdAddrs() {
        return this.pdAddrs;
    }

    public String getPdAddrsString() {
        return TiConfiguration.listToString(this.pdAddrs);
    }

    public int getScanBatchSize() {
        return 100;
    }

    boolean isIgnoreTruncate() {
        return this.ignoreTruncate;
    }

    public TiConfiguration setIgnoreTruncate(boolean ignoreTruncate) {
        this.ignoreTruncate = ignoreTruncate;
        return this;
    }

    boolean isTruncateAsWarning() {
        return this.truncateAsWarning;
    }

    public TiConfiguration setTruncateAsWarning(boolean truncateAsWarning) {
        this.truncateAsWarning = truncateAsWarning;
        return this;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public TiConfiguration setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public int getIndexScanBatchSize() {
        return this.indexScanBatchSize;
    }

    public void setIndexScanBatchSize(int indexScanBatchSize) {
        this.indexScanBatchSize = indexScanBatchSize;
    }

    public int getIndexScanConcurrency() {
        return this.indexScanConcurrency;
    }

    public void setIndexScanConcurrency(int indexScanConcurrency) {
        this.indexScanConcurrency = indexScanConcurrency;
    }

    public int getTableScanConcurrency() {
        return this.tableScanConcurrency;
    }

    public void setTableScanConcurrency(int tableScanConcurrency) {
        this.tableScanConcurrency = tableScanConcurrency;
    }

    public Kvrpcpb.CommandPri getCommandPriority() {
        return this.commandPriority;
    }

    public void setCommandPriority(Kvrpcpb.CommandPri commandPriority) {
        this.commandPriority = commandPriority;
    }

    public Kvrpcpb.IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(Kvrpcpb.IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public int getMaxRequestKeyRangeSize() {
        return this.maxRequestKeyRangeSize;
    }

    public void setMaxRequestKeyRangeSize(int maxRequestKeyRangeSize) {
        if (maxRequestKeyRangeSize <= 0) {
            throw new IllegalArgumentException("Key range size cannot be less than 1");
        }
        this.maxRequestKeyRangeSize = maxRequestKeyRangeSize;
    }

    public void setShowRowId(boolean flag) {
        this.showRowId = flag;
    }

    public boolean ifShowRowId() {
        return this.showRowId;
    }

    public String getDBPrefix() {
        return this.dbPrefix;
    }

    public void setDBPrefix(String dbPrefix) {
        this.dbPrefix = dbPrefix;
    }

    public boolean isWriteEnable() {
        return this.writeEnable;
    }

    public void setWriteEnable(boolean writeEnable) {
        this.writeEnable = writeEnable;
    }

    public boolean isWriteWithoutLockTable() {
        return this.writeWithoutLockTable;
    }

    public void setWriteWithoutLockTable(boolean writeWithoutLockTable) {
        this.writeWithoutLockTable = writeWithoutLockTable;
    }

    public boolean isWriteAllowSparkSQL() {
        return this.writeAllowSparkSQL;
    }

    public void setWriteAllowSparkSQL(boolean writeAllowSparkSQL) {
        this.writeAllowSparkSQL = writeAllowSparkSQL;
    }

    public int getTikvRegionSplitSizeInMB() {
        return this.tikvRegionSplitSizeInMB;
    }

    public void setTikvRegionSplitSizeInMB(int tikvRegionSplitSizeInMB) {
        this.tikvRegionSplitSizeInMB = tikvRegionSplitSizeInMB;
    }

    public int getDowngradeThreshold() {
        return this.downgradeThreshold;
    }

    public void setDowngradeThreshold(int downgradeThreshold) {
        this.downgradeThreshold = downgradeThreshold;
    }

    public int getPartitionPerSplit() {
        return this.partitionPerSplit;
    }

    public void setPartitionPerSplit(int partitionPerSplit) {
        this.partitionPerSplit = partitionPerSplit;
    }

    public KVMode getKvMode() {
        return this.kvMode;
    }

    public void setKvMode(String kvMode) {
        this.kvMode = KVMode.valueOf(kvMode);
    }

    public int getRawClientConcurrency() {
        return this.rawClientConcurrency;
    }

    public void setRawClientConcurrency(int rawClientConcurrency) {
        this.rawClientConcurrency = rawClientConcurrency;
    }

    public int getKvClientConcurrency() {
        return this.kvClientConcurrency;
    }

    public void setKvClientConcurrency(int kvClientConcurrency) {
        this.kvClientConcurrency = kvClientConcurrency;
    }

    public boolean isReplicaRead() {
        return this.isReplicaRead;
    }

    public void setReplicaRead(boolean isReplicaRead) {
        this.isReplicaRead = isReplicaRead;
    }

    public static enum KVMode {
        TXN,
        RAW;

    }
}

