/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.allocator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Function;
import org.tikv.common.Snapshot;
import org.tikv.common.TiConfiguration;
import org.tikv.common.TiSession;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.codec.MetaCodec;
import org.tikv.common.exception.AllocateRowIDOverflowException;
import org.tikv.common.exception.TiBatchWriteException;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.txn.TwoPhaseCommitter;
import shade.com.google.common.primitives.UnsignedLongs;
import shade.com.google.protobuf.ByteString;

public final class RowIDAllocator
implements Serializable {
    private final long maxShardRowIDBits;
    private final long dbId;
    private final TiConfiguration conf;
    private final long step;
    private long end;

    private RowIDAllocator(long maxShardRowIDBits, long dbId, long step, TiConfiguration conf) {
        this.maxShardRowIDBits = maxShardRowIDBits;
        this.dbId = dbId;
        this.step = step;
        this.conf = conf;
    }

    public long getShardRowId(long index) {
        return RowIDAllocator.getShardRowId(this.maxShardRowIDBits, index, index + this.getStart());
    }

    static long getShardRowId(long maxShardRowIDBits, long partitionIndex, long rowID) {
        if (maxShardRowIDBits <= 0L || maxShardRowIDBits >= 16L) {
            return rowID;
        }
        long partition = partitionIndex & (1L << (int)maxShardRowIDBits) - 1L;
        return rowID | partition << (int)(64L - maxShardRowIDBits - 1L);
    }

    public static RowIDAllocator create(long dbId, TiTableInfo table, TiConfiguration conf, boolean unsigned, long step) {
        RowIDAllocator allocator = new RowIDAllocator(table.getMaxShardRowIDBits(), dbId, step, conf);
        if (unsigned) {
            allocator.initUnsigned(TiSession.getInstance(conf).createSnapshot(), table.getId(), table.getMaxShardRowIDBits());
        } else {
            allocator.initSigned(TiSession.getInstance(conf).createSnapshot(), table.getId(), table.getMaxShardRowIDBits());
        }
        return allocator;
    }

    public long getStart() {
        return this.end - this.step;
    }

    public long getEnd() {
        return this.end;
    }

    private void set(ByteString key, byte[] value) {
        TiSession session = TiSession.getInstance(this.conf);
        TwoPhaseCommitter twoPhaseCommitter = new TwoPhaseCommitter(this.conf, session.getTimestamp().getVersion());
        twoPhaseCommitter.prewritePrimaryKey(ConcreteBackOffer.newCustomBackOff(20000), key.toByteArray(), value);
        twoPhaseCommitter.commitPrimaryKey(ConcreteBackOffer.newCustomBackOff(10000), key.toByteArray(), session.getTimestamp().getVersion());
        try {
            twoPhaseCommitter.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void updateMeta(ByteString key, byte[] oldVal, Snapshot snapshot) {
        CodecDataOutput cdo = new CodecDataOutput();
        ByteString metaKey = MetaCodec.encodeHashMetaKey(cdo, key.toByteArray());
        ByteString metaVal = snapshot.get(metaKey);
        long fieldCount = new CodecDataInput(metaVal.toByteArray()).readLong();
        if (oldVal == null || oldVal.length == 0) {
            cdo.reset();
            cdo.writeLong(++fieldCount);
            this.set(metaKey, cdo.toBytes());
        }
    }

    private long updateHash(ByteString key, ByteString field, Function<byte[], byte[]> calculateNewVal, Snapshot snapshot) {
        CodecDataOutput cdo = new CodecDataOutput();
        MetaCodec.encodeHashDataKey(cdo, key.toByteArray(), field.toByteArray());
        ByteString dataKey = cdo.toByteString();
        byte[] oldVal = snapshot.get(dataKey.toByteArray());
        byte[] newVal = calculateNewVal.apply(oldVal);
        if (Arrays.equals(newVal, oldVal)) {
            return 0L;
        }
        this.set(dataKey, newVal);
        this.updateMeta(key, oldVal, snapshot);
        return Long.parseLong(new String(newVal));
    }

    private static boolean isDBExisted(long dbId, Snapshot snapshot) {
        ByteString dbKey = MetaCodec.encodeDatabaseID(dbId);
        ByteString json = MetaCodec.hashGet(MetaCodec.KEY_DBs, dbKey, snapshot);
        return json != null && !json.isEmpty();
    }

    private static boolean isTableExisted(long dbId, long tableId, Snapshot snapshot) {
        ByteString tableKey;
        ByteString dbKey = MetaCodec.encodeDatabaseID(dbId);
        return !MetaCodec.hashGet(dbKey, tableKey = MetaCodec.tableKey(tableId), snapshot).isEmpty();
    }

    public static boolean shardRowBitsOverflow(long base, long step, long shardRowBits, boolean reservedSignBit) {
        long signBit = reservedSignBit ? 1L : 0L;
        long mask = (1L << (int)shardRowBits) - 1L << (int)(64L - shardRowBits - signBit);
        if (reservedSignBit) {
            return (base + step & mask) > 0L;
        }
        return Long.compareUnsigned(base + step & mask, 0L) > 0;
    }

    public long udpateAllocateId(long dbId, long tableId, long step, Snapshot snapshot, long shard, boolean hasSignedBit) {
        if (RowIDAllocator.isDBExisted(dbId, snapshot) && RowIDAllocator.isTableExisted(dbId, tableId, snapshot)) {
            return this.updateHash(MetaCodec.encodeDatabaseID(dbId), MetaCodec.autoTableIDKey(tableId), oldVal -> {
                long base = 0L;
                if (oldVal != null && ((byte[])oldVal).length != 0) {
                    base = Long.parseLong(new String((byte[])oldVal));
                }
                if (shard >= 1L && RowIDAllocator.shardRowBitsOverflow(base, step, shard, hasSignedBit)) {
                    throw new AllocateRowIDOverflowException(base, step, shard);
                }
                return String.valueOf(base += step).getBytes();
            }, snapshot);
        }
        throw new IllegalArgumentException("table or database is not existed");
    }

    public static long getAllocateId(long dbId, long tableId, Snapshot snapshot) {
        if (RowIDAllocator.isDBExisted(dbId, snapshot) && RowIDAllocator.isTableExisted(dbId, tableId, snapshot)) {
            ByteString tblKey;
            ByteString dbKey = MetaCodec.encodeDatabaseID(dbId);
            ByteString val = MetaCodec.hashGet(dbKey, tblKey = MetaCodec.autoTableIDKey(tableId), snapshot);
            if (val.isEmpty()) {
                return 0L;
            }
            return Long.parseLong(val.toStringUtf8());
        }
        throw new IllegalArgumentException("table or database is not existed");
    }

    private void initSigned(Snapshot snapshot, long tableId, long shard) {
        long newStart = RowIDAllocator.getAllocateId(this.dbId, tableId, snapshot);
        long tmpStep = Math.min(Long.MAX_VALUE - newStart, this.step);
        if (tmpStep != this.step) {
            throw new TiBatchWriteException("cannot allocate ids for this write");
        }
        if (newStart == Long.MAX_VALUE) {
            throw new TiBatchWriteException("cannot allocate more ids since it ");
        }
        this.end = this.udpateAllocateId(this.dbId, tableId, tmpStep, snapshot, shard, true);
    }

    private void initUnsigned(Snapshot snapshot, long tableId, long shard) {
        long newStart = RowIDAllocator.getAllocateId(this.dbId, tableId, snapshot);
        long tmpStep = UnsignedLongs.min(-1L - newStart, this.step);
        if (tmpStep != this.step) {
            throw new TiBatchWriteException("cannot allocate ids for this write");
        }
        if (UnsignedLongs.compare(newStart, -1L) == 0) {
            throw new TiBatchWriteException("cannot allocate more ids since the start reaches unsigned long's max value ");
        }
        this.end = this.udpateAllocateId(this.dbId, tableId, tmpStep, snapshot, shard, false);
    }
}

