/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.codec;

import org.tikv.common.codec.CodecDataOutput;
import shade.com.google.common.primitives.Longs;

public class CodecDataOutputLittleEndian
extends CodecDataOutput {
    public CodecDataOutputLittleEndian() {
    }

    public CodecDataOutputLittleEndian(int size) {
        super(size);
    }

    @Override
    public void writeShort(int v) {
        try {
            this.s.write(v & 0xFF);
            this.s.write(v >> 8 & 0xFF);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeChar(int v) {
        this.writeShort(v);
    }

    @Override
    public void writeInt(int v) {
        try {
            this.s.write(v & 0xFF);
            this.s.write(v >> 8 & 0xFF);
            this.s.write(v >> 16 & 0xFF);
            this.s.write(v >> 24 & 0xFF);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeLong(long v) {
        byte[] bytes = Longs.toByteArray(Long.reverseBytes(v));
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }
}

