/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.codec;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import shade.com.google.common.annotations.VisibleForTesting;

public class MyDecimal
implements Serializable {
    private static final int digitsPerWord = 9;
    private static final int wordBufLen = 9;
    private static final int wordSize = 4;
    private static final int ten0 = 1;
    private static final int ten1 = 10;
    private static final int ten2 = 100;
    private static final int ten3 = 1000;
    private static final int ten4 = 10000;
    private static final int ten5 = 100000;
    private static final int ten6 = 1000000;
    private static final int ten7 = 10000000;
    private static final int ten8 = 100000000;
    private static final int ten9 = 1000000000;
    private static final int digMask = 100000000;
    private static final int wordBase = 1000000000;
    private static final BigInteger wordBaseBigInt = BigInteger.valueOf(1000000000L);
    private static final int wordMax = 999999999;
    private static final int[] div9 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14};
    private static final int[] powers10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final BigInteger[] powers10BigInt = new BigInteger[]{BigInteger.valueOf(1L), BigInteger.valueOf(10L), BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L)};
    private static final int maxWordBufLen = 9;
    private static final int maxFraction = 30;
    private static final int[] dig2bytes = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 4};
    private int digitsInt;
    private int digitsFrac;
    private boolean negative;
    private int[] wordBuf = new int[9];

    public MyDecimal() {
    }

    public MyDecimal(int digitsInt, int digitsFrac, boolean negative, int[] wordBuf) {
        this.digitsInt = digitsInt;
        this.digitsFrac = digitsFrac;
        this.negative = negative;
        this.wordBuf = wordBuf;
    }

    @VisibleForTesting
    public static int readWord(int[] b, int size, int start) {
        int x = 0;
        switch (size) {
            case 1: {
                x = (byte)b[start];
                break;
            }
            case 2: {
                x = ((byte)b[start] << 8) + (b[start + 1] & 0xFF);
                break;
            }
            case 3: {
                int sign = b[start] & 0x80;
                if (sign > 0) {
                    x = 0xFF000000 | b[start] << 16 | b[start + 1] << 8 | b[start + 2];
                    break;
                }
                x = b[start] << 16 | b[start + 1] << 8 | b[start + 2];
                break;
            }
            case 4: {
                x = b[start + 3] + (b[start + 2] << 8) + (b[start + 1] << 16) + (b[start] << 24);
            }
        }
        return x;
    }

    public int precision() {
        int frac = this.digitsFrac;
        int digitsInt = this.removeLeadingZeros()[1];
        int precision = digitsInt + frac;
        if (precision == 0) {
            precision = 1;
        }
        return precision;
    }

    public int frac() {
        return this.digitsFrac;
    }

    public void fromDecimal(double value) {
        String s = Double.toString(value);
        this.fromString(s);
    }

    public int fromBin(int precision, int frac, int[] bin) {
        int x;
        int i;
        if (bin.length == 0) {
            throw new IllegalArgumentException("Bad Float Number to parse");
        }
        int _digitsInt = precision - frac;
        int _wordsInt = _digitsInt / 9;
        int _leadingDigits = _digitsInt - _wordsInt * 9;
        int _wordsFrac = frac / 9;
        int trailingDigits = frac - _wordsFrac * 9;
        int wordsIntTo = _wordsInt;
        if (_leadingDigits > 0) {
            ++wordsIntTo;
        }
        int wordsFracTo = _wordsFrac;
        if (trailingDigits > 0) {
            ++wordsFracTo;
        }
        int binIdx = 0;
        int mask = -1;
        int sign = bin[binIdx] & 0x80;
        if (sign > 0) {
            mask = 0;
        }
        int binSize = this.decimalBinSize(precision, frac);
        int[] dCopy = Arrays.copyOf(bin, binSize);
        dCopy[0] = dCopy[0] ^ 0x80;
        bin = dCopy;
        int oldWordsIntTo = wordsIntTo;
        boolean overflow = false;
        boolean truncated = false;
        if (wordsIntTo + wordsFracTo > 9) {
            if (wordsIntTo > 9) {
                wordsIntTo = 9;
                wordsFracTo = 0;
                overflow = true;
            } else {
                wordsIntTo = _wordsInt;
                wordsFracTo = 9 - _wordsInt;
                truncated = true;
            }
        }
        if (overflow || truncated) {
            if (wordsIntTo < oldWordsIntTo) {
                binIdx += dig2bytes[_leadingDigits] + (_wordsInt - wordsIntTo) * 4;
            } else {
                trailingDigits = 0;
                _wordsFrac = wordsFracTo;
            }
        }
        this.negative = mask != 0;
        this.digitsInt = (byte)(_wordsInt * 9 + _leadingDigits);
        this.digitsFrac = (byte)(_wordsFrac * 9 + trailingDigits);
        int wordIdx = 0;
        if (_leadingDigits > 0) {
            i = dig2bytes[_leadingDigits];
            x = MyDecimal.readWord(bin, i, binIdx);
            binIdx += i;
            int n = this.wordBuf[wordIdx] = (x ^ mask) > 0 ? x ^ mask : (x ^ mask) & 0xFF;
            if (this.wordBuf[wordIdx] >= powers10[_leadingDigits + 1]) {
                throw new IllegalArgumentException("BadNumber");
            }
            if (this.wordBuf[wordIdx] != 0) {
                ++wordIdx;
            } else {
                this.digitsInt -= _leadingDigits;
            }
        }
        int stop = binIdx + _wordsInt * 4;
        while (binIdx < stop) {
            this.wordBuf[wordIdx] = MyDecimal.readWord(bin, 4, binIdx) ^ mask;
            if (this.wordBuf[wordIdx] > 999999999) {
                throw new IllegalArgumentException("BadNumber");
            }
            if (wordIdx > 0 || this.wordBuf[wordIdx] != 0) {
                ++wordIdx;
            } else {
                this.digitsInt -= 9;
            }
            binIdx += 4;
        }
        stop = binIdx + _wordsFrac * 4;
        while (binIdx < stop) {
            x = MyDecimal.readWord(bin, 4, binIdx);
            int n = this.wordBuf[wordIdx] = (x ^ mask) > 0 ? x ^ mask : (x ^ mask) & 0xFF;
            if (this.wordBuf[wordIdx] > 999999999) {
                throw new IllegalArgumentException("BadNumber");
            }
            ++wordIdx;
            binIdx += 4;
        }
        if (trailingDigits > 0) {
            i = dig2bytes[trailingDigits];
            x = MyDecimal.readWord(bin, i, binIdx);
            this.wordBuf[wordIdx] = ((x ^ mask) > 0 ? x ^ mask : (x ^ mask) & 0xFF) * powers10[9 - trailingDigits];
            if (this.wordBuf[wordIdx] > 999999999) {
                throw new IllegalArgumentException("BadNumber");
            }
        }
        return binSize;
    }

    private int[] removeLeadingZeros() {
        int wordIdx = 0;
        int digitsInt = this.digitsInt;
        int i = (digitsInt - 1) % 9 + 1;
        while (digitsInt > 0 && this.wordBuf[wordIdx] == 0) {
            digitsInt -= i;
            i = 9;
            ++wordIdx;
        }
        digitsInt = digitsInt > 0 ? (digitsInt -= this.countLeadingZeroes((digitsInt - 1) % 9, this.wordBuf[wordIdx])) : 0;
        int[] res = new int[]{wordIdx, digitsInt};
        return res;
    }

    private int countLeadingZeroes(int i, int word) {
        int leading = 0;
        while (word < powers10[i]) {
            --i;
            ++leading;
        }
        return leading;
    }

    private int digitsToWords(int digits) {
        if (digits + 9 - 1 >= 0 && digits + 9 - 1 < 128) {
            return div9[digits + 9 - 1];
        }
        return (digits + 9 - 1) / 9;
    }

    @VisibleForTesting
    public void fromString(String s) {
        char[] sCharArray = s.toCharArray();
        this.fromCharArray(sCharArray);
    }

    private void fromCharArray(char[] str) {
        int digitsFrac;
        int strIdx;
        int startIdx;
        for (startIdx = 0; startIdx < str.length && Character.isSpaceChar(str[startIdx]); ++startIdx) {
        }
        if (str.length == 0) {
            throw new IllegalArgumentException("BadNumber");
        }
        switch (str[startIdx]) {
            case '-': {
                this.negative = true;
                ++startIdx;
                break;
            }
            case '+': {
                ++startIdx;
            }
        }
        for (strIdx = startIdx; strIdx < str.length && Character.isDigit(str[strIdx]); ++strIdx) {
        }
        int digitsInt = strIdx - startIdx;
        if (strIdx < str.length && str[strIdx] == '.') {
            int endIdx;
            for (endIdx = strIdx + 1; endIdx < str.length && Character.isDigit(str[endIdx]); ++endIdx) {
            }
            digitsFrac = endIdx - strIdx - 1;
        } else {
            digitsFrac = 0;
        }
        if (digitsInt + digitsFrac == 0) {
            throw new IllegalArgumentException("BadNumber");
        }
        int wordsInt = this.digitsToWords(digitsInt);
        int wordsFrac = this.digitsToWords(digitsFrac);
        boolean overflow = false;
        boolean truncated = false;
        if (wordsInt + wordsFrac > 9) {
            if (wordsInt > 9) {
                wordsInt = 9;
                wordsFrac = 0;
                overflow = true;
            } else {
                wordsFrac = 9 - wordsInt;
                truncated = true;
            }
        }
        if (overflow || truncated) {
            digitsFrac = wordsFrac * 9;
            if (overflow) {
                digitsInt = wordsInt * 9;
            }
        }
        this.digitsInt = digitsInt;
        this.digitsFrac = digitsFrac;
        int wordIdx = wordsInt;
        int strIdxTmp = strIdx;
        int word = 0;
        int innerIdx = 0;
        while (digitsInt > 0) {
            --digitsInt;
            word += (str[--strIdx] - 48) * powers10[innerIdx];
            if (++innerIdx != 9) continue;
            this.wordBuf[--wordIdx] = word;
            word = 0;
            innerIdx = 0;
        }
        if (innerIdx != 0) {
            this.wordBuf[--wordIdx] = word;
        }
        wordIdx = wordsInt;
        strIdx = strIdxTmp;
        word = 0;
        innerIdx = 0;
        while (digitsFrac > 0) {
            --digitsFrac;
            word = str[++strIdx] - 48 + word * 10;
            if (++innerIdx != 9) continue;
            this.wordBuf[wordIdx] = word;
            ++wordIdx;
            word = 0;
            innerIdx = 0;
        }
        if (innerIdx != 0) {
            this.wordBuf[wordIdx] = word * powers10[9 - innerIdx];
        }
        boolean allZero = true;
        for (int i = 0; i < 9; ++i) {
            if (this.wordBuf[i] == 0) continue;
            allZero = false;
            break;
        }
        if (allZero) {
            this.negative = false;
        }
    }

    public String toString() {
        int digitsIntLen;
        int _digitsFrac = this.digitsFrac;
        int[] res = this.removeLeadingZeros();
        int wordStartIdx = res[0];
        int digitsInt = res[1];
        if (digitsInt + _digitsFrac == 0) {
            digitsInt = 1;
            wordStartIdx = 0;
        }
        if ((digitsIntLen = digitsInt) == 0) {
            digitsIntLen = 1;
        }
        int digitsFracLen = _digitsFrac;
        int length = digitsIntLen + digitsFracLen;
        if (this.negative) {
            ++length;
        }
        if (_digitsFrac > 0) {
            ++length;
        }
        char[] str = new char[length];
        int strIdx = 0;
        if (this.negative) {
            str[strIdx] = 45;
            ++strIdx;
        }
        if (_digitsFrac > 0) {
            int fracIdx = strIdx + digitsIntLen;
            int wordIdx = wordStartIdx + this.digitsToWords(digitsInt);
            str[fracIdx] = 46;
            ++fracIdx;
            while (_digitsFrac > 0) {
                int x = this.wordBuf[wordIdx];
                ++wordIdx;
                for (int i = Math.min(_digitsFrac, 9); i > 0; --i) {
                    int y = x / 100000000;
                    str[fracIdx] = (char)((char)y + 48);
                    ++fracIdx;
                    x -= y * 100000000;
                    x *= 10;
                }
                _digitsFrac -= 9;
            }
        }
        if (digitsInt > 0) {
            strIdx += digitsInt;
            int wordIdx = wordStartIdx + this.digitsToWords(digitsInt);
            while (digitsInt > 0) {
                int x = this.wordBuf[--wordIdx];
                for (int i = Math.min(digitsInt, 9); i > 0; --i) {
                    int temp = x / 10;
                    str[--strIdx] = (char)(48 + (x - temp * 10));
                    x = temp;
                }
                digitsInt -= 9;
            }
        } else {
            str[strIdx] = 48;
        }
        return new String(str);
    }

    private int decimalBinSize(int precision, int frac) {
        int digitsInt = precision - frac;
        int wordsInt = digitsInt / 9;
        int wordsFrac = frac / 9;
        int xInt = digitsInt - wordsInt * 9;
        int xFrac = frac - wordsFrac * 9;
        return wordsInt * 4 + dig2bytes[xInt] + wordsFrac * 4 + dig2bytes[xFrac];
    }

    public int[] toBin(int precision, int frac) {
        int x;
        if (precision > 81 || precision < 0 || frac > 30 || frac < 0) {
            throw new IllegalArgumentException("BadNumber");
        }
        int mask = 0;
        if (this.negative) {
            mask = -1;
        }
        int digitsInt = precision - frac;
        int wordsInt = digitsInt / 9;
        int leadingDigits = digitsInt - wordsInt * 9;
        int wordsFrac = frac / 9;
        int trailingDigits = frac - wordsFrac * 9;
        int wordsFracFrom = this.digitsFrac / 9;
        int trailingDigitsFrom = this.digitsFrac - wordsFracFrom * 9;
        int intSize = wordsInt * 4 + dig2bytes[leadingDigits];
        int fracSize = wordsFrac * 4 + dig2bytes[trailingDigits];
        int fracSizeFrom = wordsFracFrom * 4 + dig2bytes[trailingDigitsFrom];
        int originIntSize = intSize;
        int originFracSize = fracSize;
        int[] bin = new int[intSize + fracSize];
        int binIdx = 0;
        int[] res = this.removeLeadingZeros();
        int wordIdxFrom = res[0];
        int digitsIntFrom = res[1];
        if (digitsIntFrom + fracSizeFrom == 0) {
            mask = 0;
            digitsInt = 1;
        }
        int wordsIntFrom = digitsIntFrom / 9;
        int leadingDigitsFrom = digitsIntFrom - wordsIntFrom * 9;
        int iSizeFrom = wordsIntFrom * 4 + dig2bytes[leadingDigitsFrom];
        if (digitsInt < digitsIntFrom) {
            wordIdxFrom += wordsIntFrom - wordsInt;
            if (leadingDigitsFrom > 0) {
                ++wordIdxFrom;
            }
            if (leadingDigits > 0) {
                --wordIdxFrom;
            }
            wordsIntFrom = wordsInt;
            leadingDigitsFrom = leadingDigits;
        } else if (intSize > iSizeFrom) {
            while (intSize > iSizeFrom) {
                --intSize;
                bin[binIdx] = mask & 0xFF;
                ++binIdx;
            }
        }
        if (fracSize < fracSizeFrom) {
            wordsFracFrom = wordsFrac;
            trailingDigitsFrom = trailingDigits;
        } else if (fracSize > fracSizeFrom && trailingDigitsFrom > 0) {
            if (wordsFrac == wordsFracFrom) {
                trailingDigitsFrom = trailingDigits;
                fracSize = fracSizeFrom;
            } else {
                ++wordsFracFrom;
                trailingDigitsFrom = 0;
            }
        }
        if (leadingDigitsFrom > 0) {
            int i = dig2bytes[leadingDigitsFrom];
            x = this.wordBuf[wordIdxFrom] % powers10[leadingDigitsFrom] ^ mask;
            ++wordIdxFrom;
            this.writeWord(bin, x, i, binIdx);
            binIdx += i;
        }
        int stop = wordIdxFrom + wordsIntFrom + wordsFracFrom;
        while (wordIdxFrom < stop) {
            x = this.wordBuf[wordIdxFrom] ^ mask;
            ++wordIdxFrom;
            this.writeWord(bin, x, 4, binIdx);
            binIdx += 4;
        }
        if (trailingDigitsFrom > 0) {
            int i = dig2bytes[trailingDigitsFrom];
            int lim = trailingDigits;
            if (wordsFracFrom < wordsFrac) {
                lim = 9;
            }
            while (trailingDigitsFrom < lim && dig2bytes[trailingDigitsFrom] == i) {
                ++trailingDigitsFrom;
            }
            int x2 = this.wordBuf[wordIdxFrom] / powers10[9 - trailingDigitsFrom] ^ mask;
            this.writeWord(bin, x2, i, binIdx);
            binIdx += i;
        }
        if (fracSize > fracSizeFrom) {
            int binIdxEnd = originIntSize + originFracSize;
            while (fracSize > fracSizeFrom && binIdx < binIdxEnd) {
                --fracSize;
                bin[binIdx] = mask & 0xFF;
                ++binIdx;
            }
        }
        bin[0] = bin[0] ^ 0x80;
        return bin;
    }

    private void writeWord(int[] b, int word, int size, int start) {
        switch (size) {
            case 1: {
                b[start] = word & 0xFF;
                break;
            }
            case 2: {
                b[start] = word >>> 8 & 0xFF;
                b[start + 1] = word & 0xFF;
                break;
            }
            case 3: {
                b[start] = word >>> 16 & 0xFF;
                b[start + 1] = word >>> 8 & 0xFF;
                b[start + 2] = word & 0xFF;
                break;
            }
            case 4: {
                b[start] = word >>> 24 & 0xFF;
                b[start + 1] = word >>> 16 & 0xFF;
                b[start + 2] = word >>> 8 & 0xFF;
                b[start + 3] = word & 0xFF;
            }
        }
    }

    public void clear() {
        this.digitsFrac = 0;
        this.digitsInt = 0;
        this.negative = false;
    }

    private BigInteger toBigInteger() {
        int i;
        BigInteger x = BigInteger.ZERO;
        int wordIdx = 0;
        for (i = this.digitsInt; i > 0; i -= 9) {
            x = x.multiply(wordBaseBigInt).add(BigInteger.valueOf(this.wordBuf[wordIdx]));
            ++wordIdx;
        }
        for (i = this.digitsFrac; i > 0; i -= 9) {
            x = x.multiply(wordBaseBigInt).add(BigInteger.valueOf(this.wordBuf[wordIdx]));
            ++wordIdx;
        }
        if (this.digitsFrac % 9 != 0) {
            x = x.divide(powers10BigInt[9 - this.digitsFrac % 9]);
        }
        if (this.negative) {
            x = x.negate();
        }
        return x;
    }

    public long toLong() {
        int i;
        long x = 0L;
        int wordIdx = 0;
        for (i = this.digitsInt; i > 0; i -= 9) {
            x = x * 1000000000L + (long)this.wordBuf[wordIdx];
            ++wordIdx;
        }
        for (i = this.digitsFrac; i > 0; i -= 9) {
            x = x * 1000000000L + (long)this.wordBuf[wordIdx];
            ++wordIdx;
        }
        if (this.digitsFrac % 9 != 0) {
            x /= (long)powers10[9 - this.digitsFrac % 9];
        }
        if (this.negative) {
            x = -x;
        }
        return x;
    }

    public BigDecimal toBigDecimal() {
        if (this.digitsInt + this.digitsFrac < 19) {
            return new BigDecimal(BigInteger.valueOf(this.toLong()), this.digitsFrac);
        }
        return new BigDecimal(this.toBigInteger(), this.digitsFrac);
    }
}

