/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.columnar;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import org.joda.time.LocalDate;
import org.tikv.common.columnar.TiColumnVector;
import org.tikv.common.columnar.datatypes.CHType;
import org.tikv.common.types.AbstractDateTimeType;
import org.tikv.common.types.BytesType;
import org.tikv.common.types.DateType;
import org.tikv.common.util.MemoryUtil;

public class TiBlockColumnVector
extends TiColumnVector {
    long offsetsAddr;
    ByteBuffer offsets;
    long nullMapAddr;
    ByteBuffer nullMap;
    long dataAddr;
    ByteBuffer data;
    private int fixedLength;

    public TiBlockColumnVector(CHType type, ByteBuffer data, int numOfRows, int fixedLength) {
        super(type.toDataType(), numOfRows);
        this.data = data;
        this.dataAddr = MemoryUtil.getAddress(data);
        this.fillEmptyNullMap();
        this.fillEmptyOffsets();
        this.fixedLength = fixedLength;
    }

    public TiBlockColumnVector(CHType type) {
        super(type.toDataType(), 0);
    }

    public TiBlockColumnVector(CHType type, ByteBuffer nullMap, ByteBuffer data, int numOfRows, int fixedLength) {
        super(type.toDataType(), numOfRows);
        this.nullMap = nullMap;
        this.nullMapAddr = MemoryUtil.getAddress(nullMap);
        this.data = data;
        this.dataAddr = MemoryUtil.getAddress(data);
        this.fillEmptyOffsets();
        this.fixedLength = fixedLength;
    }

    public TiBlockColumnVector(CHType type, ByteBuffer nullMap, ByteBuffer offsets, ByteBuffer data, int numOfRows) {
        super(type.toDataType(), numOfRows);
        this.offsets = offsets;
        this.offsetsAddr = MemoryUtil.getAddress(offsets);
        this.nullMap = nullMap;
        this.nullMapAddr = MemoryUtil.getAddress(nullMap);
        this.data = data;
        this.dataAddr = MemoryUtil.getAddress(data);
        this.fixedLength = -1;
    }

    private void fillEmptyNullMap() {
        this.nullMap = MemoryUtil.EMPTY_BYTE_BUFFER_DIRECT;
        this.nullMapAddr = MemoryUtil.getAddress(this.nullMap);
    }

    private void fillEmptyOffsets() {
        this.offsets = MemoryUtil.EMPTY_BYTE_BUFFER_DIRECT;
        this.offsetsAddr = MemoryUtil.getAddress(this.offsets);
    }

    @Override
    public void close() {
        if (this.dataAddr != 0L) {
            MemoryUtil.free(this.data);
        }
        if (this.offsetsAddr != 0L) {
            MemoryUtil.free(this.offsets);
        }
        if (this.nullMapAddr != 0L) {
            MemoryUtil.free(this.nullMap);
        }
        this.dataAddr = 0L;
        this.offsetsAddr = 0L;
        this.nullMapAddr = 0L;
    }

    @Override
    public boolean hasNull() {
        return this.nullMap == null;
    }

    @Override
    public int numNulls() {
        throw new UnsupportedOperationException("numNulls is not supported for TiBlockColumnVector");
    }

    @Override
    public boolean isNullAt(int rowId) {
        if (this.nullMap == MemoryUtil.EMPTY_BYTE_BUFFER_DIRECT) {
            return false;
        }
        return MemoryUtil.getByte(this.nullMapAddr + (long)rowId) != 0;
    }

    @Override
    public boolean getBoolean(int rowId) {
        return false;
    }

    @Override
    public byte getByte(int rowId) {
        return MemoryUtil.getByte(this.dataAddr + (long)rowId);
    }

    @Override
    public short getShort(int rowId) {
        return MemoryUtil.getShort(this.dataAddr + (long)(rowId << 1));
    }

    @Override
    public int getInt(int rowId) {
        if (this.type instanceof DateType) {
            return (int)this.getTime(rowId);
        }
        return MemoryUtil.getInt(this.dataAddr + (long)(rowId << 2));
    }

    private long getDateTime(int rowId) {
        long v = MemoryUtil.getLong(this.dataAddr + (long)(rowId << 3));
        long ymdhms = v >>> 24;
        long ymd = ymdhms >>> 17;
        int day = (int)(ymd & 0x1FL);
        long ym = ymd >>> 5;
        int month = (int)(ym % 13L);
        int year = (int)(ym / 13L);
        int hms = (int)(ymdhms & 0x1FFFFL);
        int second = hms & 0x3F;
        int minute = hms >>> 6 & 0x3F;
        int hour = hms >>> 12;
        int microsec = (int)(v % 0x1000000L);
        Timestamp ts = new Timestamp(year - 1900, month - 1, day, hour, minute, second, microsec * 1000);
        return ts.getTime() / 1000L * 1000000L + (long)(ts.getNanos() / 1000);
    }

    private long getTime(int rowId) {
        long v = MemoryUtil.getLong(this.dataAddr + (long)(rowId << 3));
        long ymd = v >>> 41;
        long ym = ymd >>> 5;
        int year = (int)(ym / 13L);
        int month = (int)(ym % 13L);
        int day = (int)(ymd & 0x1FL);
        LocalDate date = new LocalDate(year, month, day);
        return ((DateType)this.type).getDays(date);
    }

    @Override
    public long getLong(int rowId) {
        if (this.type instanceof AbstractDateTimeType) {
            return this.getDateTime(rowId);
        }
        if (this.fixedLength == 1) {
            return this.getByte(rowId);
        }
        if (this.fixedLength == 2) {
            return this.getShort(rowId);
        }
        if (this.fixedLength == 4) {
            return this.getInt(rowId);
        }
        if (this.fixedLength == 8) {
            return MemoryUtil.getLong(this.dataAddr + (long)(rowId * this.fixedLength));
        }
        throw new UnsupportedOperationException(String.format("getting long with fixed length %d", this.fixedLength));
    }

    @Override
    public float getFloat(int rowId) {
        return MemoryUtil.getFloat(this.dataAddr + (long)(rowId * this.fixedLength));
    }

    @Override
    public double getDouble(int rowId) {
        return MemoryUtil.getDouble(this.dataAddr + (long)(rowId * this.fixedLength));
    }

    @Override
    public BigDecimal getDecimal(int rowId, int precision, int scale) {
        long rowIdAddr = (long)(rowId * this.fixedLength) + this.dataAddr;
        if (this.fixedLength == 4) {
            return MemoryUtil.getDecimal32(rowIdAddr, scale);
        }
        if (this.fixedLength == 8) {
            return MemoryUtil.getDecimal64(rowIdAddr, scale);
        }
        if (this.fixedLength == 16) {
            return MemoryUtil.getDecimal128(rowIdAddr, scale);
        }
        return MemoryUtil.getDecimal256(rowIdAddr, scale);
    }

    private long offsetAt(int i) {
        return i == 0 ? 0L : MemoryUtil.getLong(this.offsetsAddr + (long)(i - 1 << 3));
    }

    public int sizeAt(int i) {
        return (int)(i == 0 ? MemoryUtil.getLong(this.offsetsAddr) : MemoryUtil.getLong(this.offsetsAddr + (long)(i << 3)) - MemoryUtil.getLong(this.offsetsAddr + (long)(i - 1 << 3)));
    }

    @Override
    public String getUTF8String(int rowId) {
        if (this.fixedLength != -1) {
            byte[] chars = new byte[this.fixedLength];
            MemoryUtil.getBytes((int)(this.dataAddr + (long)(this.fixedLength * rowId)), chars, 0, this.fixedLength);
            return new String(chars);
        }
        long offset = this.dataAddr + this.offsetAt(rowId);
        int numBytes = this.sizeAt(rowId) - 1;
        byte[] chars = new byte[numBytes];
        MemoryUtil.getBytes(offset, chars, 0, numBytes);
        return new String(chars, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getBinary(int rowId) {
        if (this.type.equals(BytesType.BLOB) || this.type.equals(BytesType.TINY_BLOB)) {
            long offset = this.dataAddr + this.offsetAt(rowId);
            int numBytes = this.sizeAt(rowId) - 1;
            byte[] ret = new byte[numBytes];
            MemoryUtil.getBytes(offset, ret, 0, numBytes);
            return ret;
        }
        throw new UnsupportedOperationException("get Binary for TiBlockColumnVector is not supported");
    }

    @Override
    protected TiColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("getChild is not supported for TiBlockColumnVector");
    }
}

