/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.columnar.datatypes;

import java.nio.ByteBuffer;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.columnar.TiBlockColumnVector;
import org.tikv.common.types.DataType;
import org.tikv.common.util.MemoryUtil;

public abstract class CHType {
    protected int length;
    protected boolean nullable = false;

    abstract String name();

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    protected ByteBuffer decodeNullMap(CodecDataInput cdi, int size) {
        ByteBuffer buffer = MemoryUtil.allocateDirect(size);
        MemoryUtil.readFully(buffer, cdi, size);
        buffer.clear();
        return buffer;
    }

    public abstract DataType toDataType();

    protected int bufferSize(int size) {
        return size * this.length;
    }

    public TiBlockColumnVector decode(CodecDataInput cdi, int size) {
        if (this.length == -1) {
            throw new IllegalStateException("var type should have its own decode method");
        }
        if (size == 0) {
            return new TiBlockColumnVector(this);
        }
        if (this.isNullable()) {
            ByteBuffer nullMap = this.decodeNullMap(cdi, size);
            ByteBuffer buffer = MemoryUtil.allocateDirect(this.bufferSize(size));
            MemoryUtil.readFully(buffer, cdi, this.bufferSize(size));
            buffer.clear();
            return new TiBlockColumnVector(this, nullMap, buffer, size, this.length);
        }
        ByteBuffer buffer = MemoryUtil.allocateDirect(this.bufferSize(size));
        MemoryUtil.readFully(buffer, cdi, this.bufferSize(size));
        buffer.clear();
        return new TiBlockColumnVector(this, buffer, size, this.length);
    }
}

