/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.columnar.datatypes;

import java.nio.ByteBuffer;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.columnar.TiBlockColumnVector;
import org.tikv.common.columnar.datatypes.AutoGrowByteBuffer;
import org.tikv.common.columnar.datatypes.CHType;
import org.tikv.common.types.DataType;
import org.tikv.common.types.StringType;
import org.tikv.common.util.MemoryUtil;
import shade.com.google.common.base.Preconditions;

public class CHTypeString
extends CHType {
    private static final ThreadLocal<ByteBuffer> initBuffer = ThreadLocal.withInitial(() -> MemoryUtil.allocateDirect(102400));

    public CHTypeString() {
        this.length = -1;
    }

    @Override
    public String name() {
        return "String";
    }

    @Override
    public DataType toDataType() {
        return StringType.TEXT;
    }

    @Override
    public TiBlockColumnVector decode(CodecDataInput cdi, int size) {
        if (size == 0) {
            return new TiBlockColumnVector(this);
        }
        ByteBuffer nullMap = this.isNullable() ? this.decodeNullMap(cdi, size) : MemoryUtil.EMPTY_BYTE_BUFFER_DIRECT;
        ByteBuffer offsets = MemoryUtil.allocateDirect(size << 3);
        ByteBuffer initCharsBuf = initBuffer.get();
        AutoGrowByteBuffer autoGrowCharsBuf = new AutoGrowByteBuffer(initCharsBuf);
        int offset = 0;
        for (int i = 0; i < size; ++i) {
            int valueSize = (int)Codec.IntegerCodec.readUVarLong(cdi);
            offsets.putLong(offset += valueSize + 1);
            autoGrowCharsBuf.put(cdi, valueSize);
            autoGrowCharsBuf.putByte((byte)0);
        }
        Preconditions.checkState(offset == autoGrowCharsBuf.dataSize());
        ByteBuffer chars = autoGrowCharsBuf.getByteBuffer();
        if (chars == initCharsBuf) {
            ByteBuffer newChars = MemoryUtil.allocateDirect(offset);
            MemoryUtil.copyMemory(MemoryUtil.getAddress(chars), MemoryUtil.getAddress(newChars), offset);
            chars = newChars;
        }
        return new TiBlockColumnVector((CHType)this, nullMap, offsets, chars, size);
    }
}

