/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;
import org.tikv.common.exception.TiExpressionException;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.Visitor;
import org.tikv.common.types.BytesType;
import org.tikv.common.types.DataType;
import org.tikv.common.types.DateTimeType;
import org.tikv.common.types.DateType;
import org.tikv.common.types.DecimalType;
import org.tikv.common.types.IntegerType;
import org.tikv.common.types.RealType;
import org.tikv.common.types.StringType;
import org.tikv.common.types.TimestampType;
import shade.com.google.common.collect.ImmutableList;
import shade.com.google.common.primitives.UnsignedLong;

public class Constant
extends Expression {
    private final Object value;
    private final BigDecimal UNSIGNED_LONG_MAX = new BigDecimal(UnsignedLong.fromLongBits(-1L).toString());

    public Constant(Object value, DataType type) {
        this.value = value;
        this.dataType = type == null && value != null ? Constant.getDefaultType(value) : type;
        this.resolved = true;
    }

    public static Constant create(Object value, DataType type) {
        return new Constant(value, type);
    }

    @Deprecated
    public static Constant create(Object value) {
        return new Constant(value, null);
    }

    protected static boolean isIntegerType(Object value) {
        return value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte;
    }

    private static DataType getDefaultType(Object value) {
        if (value == null) {
            throw new TiExpressionException("NULL constant has no type");
        }
        if (Constant.isIntegerType(value)) {
            return IntegerType.BIGINT;
        }
        if (value instanceof String) {
            return StringType.VARCHAR;
        }
        if (value instanceof Float) {
            return RealType.FLOAT;
        }
        if (value instanceof Double) {
            return RealType.DOUBLE;
        }
        if (value instanceof BigDecimal) {
            int prec = ((BigDecimal)value).precision();
            int frac = ((BigDecimal)value).scale();
            return new DecimalType(prec, frac);
        }
        if (value instanceof DateTime) {
            return DateTimeType.DATETIME;
        }
        if (value instanceof Date) {
            return DateType.DATE;
        }
        if (value instanceof Timestamp) {
            return TimestampType.TIMESTAMP;
        }
        if (value instanceof byte[]) {
            return BytesType.TEXT;
        }
        throw new TiExpressionException("Constant type not supported:" + value.getClass().getSimpleName());
    }

    public void setType(DataType type) {
        this.dataType = type;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof String) {
            return String.format("\"%s\"", this.value);
        }
        return this.value.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof Constant) {
            return Objects.equals(this.value, ((Constant)other).value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public boolean isOverflowed() {
        if (this.dataType instanceof IntegerType && ((IntegerType)this.dataType).isUnsignedLong()) {
            return ((BigDecimal)this.value).min(this.UNSIGNED_LONG_MAX).signum() > 0 || ((BigDecimal)this.value).signum() < 0;
        }
        return false;
    }
}

