/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.tikv.common.exception.UnsupportedPartitionExprException;
import org.tikv.common.exception.UnsupportedSyntaxException;
import org.tikv.common.expression.ColumnRef;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.PartitionPruner;
import org.tikv.common.expression.visitor.PartAndFilterExprRewriter;
import org.tikv.common.expression.visitor.PrunedPartitionBuilder;
import org.tikv.common.meta.TiPartitionDef;
import org.tikv.common.meta.TiPartitionInfo;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.parser.TiParser;
import org.tikv.common.predicates.PredicateUtils;
import shade.com.google.common.collect.RangeSet;

public class RangePartitionPruner {
    private final TiPartitionInfo partInfo;
    private final Set<ColumnRef> partExprColRefs = new HashSet<ColumnRef>();
    private Expression partExpr;
    private List<Expression> partExprs;
    private PrunedPartitionBuilder rangeBuilder;
    private boolean foundUnsupportedPartExpr;

    RangePartitionPruner(TiTableInfo tableInfo) {
        this.partInfo = tableInfo.getPartitionInfo();
        try {
            this.partExprs = this.generateRangePartExprs(tableInfo);
            this.rangeBuilder = new PrunedPartitionBuilder(this.partExprColRefs);
        }
        catch (UnsupportedPartitionExprException | UnsupportedSyntaxException e) {
            this.foundUnsupportedPartExpr = true;
        }
    }

    private List<TiPartitionDef> pruneRangeNormalPart(Expression cnfExpr) {
        Objects.requireNonNull(cnfExpr, "cnf expression cannot be null at pruning stage");
        PartAndFilterExprRewriter expressionRewriter = new PartAndFilterExprRewriter(this.partExpr);
        cnfExpr = expressionRewriter.rewrite(cnfExpr);
        if (expressionRewriter.isUnsupportedPartFnFound()) {
            return this.partInfo.getDefs();
        }
        RangeSet filterRange = this.rangeBuilder.buildRange(cnfExpr);
        ArrayList<TiPartitionDef> pDefs = new ArrayList<TiPartitionDef>();
        for (int i = 0; i < this.partExprs.size(); ++i) {
            Expression partExpr = this.partExprs.get(i);
            RangeSet partRange = this.rangeBuilder.buildRange(expressionRewriter.rewrite(partExpr));
            partRange.removeAll(filterRange.complement());
            if (partRange.isEmpty()) continue;
            pDefs.add(this.partInfo.getDefs().get(i));
        }
        return pDefs;
    }

    private List<Expression> generateRangePartExprs(TiTableInfo tableInfo) {
        TiPartitionInfo partInfo = tableInfo.getPartitionInfo();
        ArrayList<Expression> partExprs = new ArrayList<Expression>();
        TiParser parser = new TiParser(tableInfo);
        String partExprStr = tableInfo.getPartitionInfo().getExpr();
        this.partExpr = parser.parseExpression(partExprStr);
        if (this.partExpr == null) {
            throw new UnsupportedPartitionExprException(String.format("%s is not supported", partExprStr));
        }
        this.partExprColRefs.addAll(PredicateUtils.extractColumnRefFromExpression(this.partExpr));
        PartitionPruner.generateRangeExprs(partInfo, partExprs, parser, partExprStr, 0);
        return partExprs;
    }

    public List<TiPartitionDef> prune(List<Expression> filters) {
        Expression cnfExpr = PredicateUtils.mergeCNFExpressions(filters = PartitionPruner.extractLogicalOrComparisonExpr(filters));
        if (!this.canBePruned(cnfExpr)) {
            return this.partInfo.getDefs();
        }
        return this.pruneRangeNormalPart(cnfExpr);
    }

    public boolean canBePruned(Expression filter) {
        if (this.foundUnsupportedPartExpr) {
            return false;
        }
        return filter != null;
    }
}

