/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.meta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import org.tikv.common.meta.CIStr;
import org.tikv.common.meta.SchemaState;
import org.tikv.common.meta.TiTableInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TiDBInfo
implements Serializable {
    private final long id;
    private final String name;
    private final String charset;
    private final String collate;
    private final List<TiTableInfo> tables;
    private final SchemaState schemaState;

    @JsonCreator
    public TiDBInfo(@JsonProperty(value="id") long id, @JsonProperty(value="db_name") CIStr name, @JsonProperty(value="charset") String charset, @JsonProperty(value="collate") String collate, @JsonProperty(value="-") List<TiTableInfo> tables, @JsonProperty(value="state") int schemaState) {
        this.id = id;
        this.name = name.getL();
        this.charset = charset;
        this.collate = collate;
        this.tables = tables;
        this.schemaState = SchemaState.fromValue(schemaState);
    }

    private TiDBInfo(long id, String name, String charset, String collate, List<TiTableInfo> tables, SchemaState schemaState) {
        this.id = id;
        this.name = name;
        this.charset = charset;
        this.collate = collate;
        this.tables = tables;
        this.schemaState = schemaState;
    }

    public TiDBInfo rename(String newName) {
        return new TiDBInfo(this.id, newName, this.charset, this.collate, this.tables, this.schemaState);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCollate() {
        return this.collate;
    }

    public List<TiTableInfo> getTables() {
        return this.tables;
    }

    SchemaState getSchemaState() {
        return this.schemaState;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TiDBInfo)) {
            return false;
        }
        TiDBInfo otherDB = (TiDBInfo)other;
        return otherDB.getId() == this.getId() && otherDB.getName().equals(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + Long.hashCode(this.getId());
        return result * 31 + this.getName().hashCode();
    }
}

