/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.meta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingcap.tidb.tipb.ColumnInfo;
import com.pingcap.tidb.tipb.IndexInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.tikv.common.exception.TiKVException;
import org.tikv.common.meta.CIStr;
import org.tikv.common.meta.IndexType;
import org.tikv.common.meta.SchemaState;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.meta.TiIndexColumn;
import org.tikv.common.meta.TiTableInfo;
import shade.com.google.common.annotations.VisibleForTesting;
import shade.com.google.common.base.Joiner;
import shade.com.google.common.collect.ImmutableList;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TiIndexInfo
implements Serializable {
    private final long id;
    private final String name;
    private final String tableName;
    private final List<TiIndexColumn> indexColumns;
    private final boolean isUnique;
    private final boolean isPrimary;
    private final SchemaState schemaState;
    private final String comment;
    private final IndexType indexType;
    private final boolean isFakePrimaryKey;
    private long indexColumnSize = 9L;

    @JsonCreator
    @VisibleForTesting
    public TiIndexInfo(@JsonProperty(value="id") long id, @JsonProperty(value="idx_name") CIStr name, @JsonProperty(value="tbl_name") CIStr tableName, @JsonProperty(value="idx_cols") List<TiIndexColumn> indexColumns, @JsonProperty(value="is_unique") boolean isUnique, @JsonProperty(value="is_primary") boolean isPrimary, @JsonProperty(value="state") int schemaState, @JsonProperty(value="comment") String comment, @JsonProperty(value="index_type") int indexType, @JsonProperty(value="___isFakePrimaryKey") boolean isFakePrimaryKey) {
        this.id = id;
        this.name = Objects.requireNonNull(name, "index name is null").getL();
        this.tableName = Objects.requireNonNull(tableName, "table name is null").getL();
        this.indexColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(indexColumns, "indexColumns is null"));
        this.isUnique = isUnique;
        this.isPrimary = isPrimary;
        this.schemaState = SchemaState.fromValue(schemaState);
        this.comment = comment;
        this.indexType = IndexType.fromValue(indexType);
        this.isFakePrimaryKey = isFakePrimaryKey;
    }

    public static TiIndexInfo generateFakePrimaryKeyIndex(TiTableInfo table) {
        TiColumnInfo pkColumn = table.getPKIsHandleColumn();
        if (pkColumn != null) {
            return new TiIndexInfo(-1L, CIStr.newCIStr("fake_pk_" + table.getId()), CIStr.newCIStr(table.getName()), ImmutableList.of(pkColumn.toFakeIndexColumn()), true, true, SchemaState.StatePublic.getStateCode(), "Fake Column", IndexType.IndexTypeHash.getTypeCode(), true);
        }
        return null;
    }

    private long calculateIndexColumnSize(TiIndexColumn indexColumn, List<TiColumnInfo> columns) {
        for (TiColumnInfo column : columns) {
            if (!column.getName().equalsIgnoreCase(indexColumn.getName())) continue;
            return column.getType().getSize();
        }
        throw new TiKVException(String.format("Index column [%s] not found in table [%s] columns [%s]", indexColumn.getName(), this.getTableName(), columns));
    }

    void calculateIndexSize(List<TiColumnInfo> columns) {
        long ret = 0L;
        for (TiIndexColumn indexColumn : this.indexColumns) {
            if (indexColumn.isLengthUnspecified()) {
                ret += this.calculateIndexColumnSize(indexColumn, columns);
                continue;
            }
            ret += indexColumn.getLength();
        }
        this.indexColumnSize = ret;
    }

    public long getIndexColumnSize() {
        return this.indexColumnSize;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<TiIndexColumn> getIndexColumns() {
        return this.indexColumns;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public SchemaState getSchemaState() {
        return this.schemaState;
    }

    public String getComment() {
        return this.comment;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public IndexInfo toProto(TiTableInfo tableInfo) {
        IndexInfo.Builder builder = IndexInfo.newBuilder().setTableId(tableInfo.getId()).setIndexId(this.id).setUnique(this.isUnique);
        List<TiColumnInfo> columns = tableInfo.getColumns();
        for (TiIndexColumn indexColumn : this.getIndexColumns()) {
            int offset = indexColumn.getOffset();
            TiColumnInfo column = columns.get(offset);
            builder.addColumns(column.toProto(tableInfo));
        }
        if (tableInfo.isPkHandle()) {
            for (TiColumnInfo column : columns) {
                if (!column.isPrimaryKey()) continue;
                ColumnInfo pbColumn = column.toProto(tableInfo);
                builder.addColumns(pbColumn);
            }
        }
        return builder.build();
    }

    public boolean isFakePrimaryKey() {
        return this.isFakePrimaryKey;
    }

    public String toString() {
        return String.format("%s[%s]", this.name, Joiner.on(",").skipNulls().join(this.indexColumns.stream().map(TiIndexColumn::getName).collect(Collectors.toList())));
    }
}

