/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.meta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingcap.tidb.tipb.TableInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.meta.CIStr;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.meta.TiFlashReplicaInfo;
import org.tikv.common.meta.TiIndexInfo;
import org.tikv.common.meta.TiPartitionInfo;
import org.tikv.common.meta.TiSequenceInfo;
import org.tikv.common.meta.TiViewInfo;
import org.tikv.common.types.DataType;
import org.tikv.common.types.DataTypeFactory;
import shade.com.google.common.collect.ImmutableList;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TiTableInfo
implements Serializable {
    private final long id;
    private final String name;
    private final String charset;
    private final String collate;
    private final List<TiColumnInfo> columns;
    private final Map<String, TiColumnInfo> columnsMap;
    private final List<TiIndexInfo> indices;
    private final boolean pkIsHandle;
    private final String comment;
    private final long autoIncId;
    private final long maxColumnId;
    private final long maxIndexId;
    private final long oldSchemaId;
    private final long rowSize;
    private final TiPartitionInfo partitionInfo;
    private final TiColumnInfo primaryKeyColumn;
    private final TiViewInfo viewInfo;
    private final TiFlashReplicaInfo tiflashReplicaInfo;
    private final long version;
    private final long updateTimestamp;
    private final long maxShardRowIDBits;
    private final TiSequenceInfo sequenceInfo;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public TiTableInfo(@JsonProperty(value="id") long id, @JsonProperty(value="name") CIStr name, @JsonProperty(value="charset") String charset, @JsonProperty(value="collate") String collate, @JsonProperty(value="pk_is_handle") boolean pkIsHandle, @JsonProperty(value="cols") List<TiColumnInfo> columns, @JsonProperty(value="index_info") List<TiIndexInfo> indices, @JsonProperty(value="comment") String comment, @JsonProperty(value="auto_inc_id") long autoIncId, @JsonProperty(value="max_col_id") long maxColumnId, @JsonProperty(value="max_idx_id") long maxIndexId, @JsonProperty(value="old_schema_id") long oldSchemaId, @JsonProperty(value="partition") TiPartitionInfo partitionInfo, @JsonProperty(value="view") TiViewInfo viewInfo, @JsonProperty(value="tiflash_replica") TiFlashReplicaInfo tiFlashReplicaInfo, @JsonProperty(value="version") long version, @JsonProperty(value="update_timestamp") long updateTimestamp, @JsonProperty(value="max_shard_row_id_bits") long maxShardRowIDBits, @JsonProperty(value="sequence") TiSequenceInfo sequenceInfo) {
        this.id = id;
        this.name = name.getL();
        this.charset = charset;
        this.collate = collate;
        if (sequenceInfo == null) {
            this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
            this.columnsMap = new HashMap<String, TiColumnInfo>();
            for (TiColumnInfo col : this.columns) {
                this.columnsMap.put(col.getName(), col);
            }
            this.rowSize = columns.stream().mapToLong(TiColumnInfo::getSize).sum();
        } else {
            this.columns = null;
            this.columnsMap = null;
            this.rowSize = 9L;
        }
        this.pkIsHandle = pkIsHandle;
        List<Object> list = this.indices = indices != null ? ImmutableList.copyOf(indices) : ImmutableList.of();
        if (this.columns != null) {
            this.indices.forEach(x -> x.calculateIndexSize(columns));
        }
        this.comment = comment;
        this.autoIncId = autoIncId;
        this.maxColumnId = maxColumnId;
        this.maxIndexId = maxIndexId;
        this.oldSchemaId = oldSchemaId;
        this.partitionInfo = partitionInfo;
        this.viewInfo = viewInfo;
        this.tiflashReplicaInfo = tiFlashReplicaInfo;
        this.version = version;
        this.updateTimestamp = updateTimestamp;
        this.maxShardRowIDBits = maxShardRowIDBits;
        this.sequenceInfo = sequenceInfo;
        TiColumnInfo primaryKey = null;
        if (sequenceInfo == null) {
            for (TiColumnInfo col : this.columns) {
                if (!col.isPrimaryKey()) continue;
                primaryKey = col;
                break;
            }
        }
        this.primaryKeyColumn = primaryKey;
    }

    public boolean isView() {
        return this.viewInfo != null;
    }

    public boolean isSequence() {
        return this.sequenceInfo != null;
    }

    public boolean hasAutoIncrementColumn() {
        if (this.primaryKeyColumn != null) {
            return this.primaryKeyColumn.isAutoIncrement();
        }
        return false;
    }

    public TiColumnInfo getAutoIncrementColInfo() {
        if (this.hasAutoIncrementColumn()) {
            return this.primaryKeyColumn;
        }
        return null;
    }

    public boolean isAutoIncColUnsigned() {
        TiColumnInfo col = this.getAutoIncrementColInfo();
        if (col == null) {
            return false;
        }
        return col.getType().isUnsigned();
    }

    public long getMaxShardRowIDBits() {
        return this.maxShardRowIDBits;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCollate() {
        return this.collate;
    }

    public List<TiColumnInfo> getColumns() {
        return this.columns;
    }

    public long getEstimatedRowSizeInByte() {
        return this.rowSize;
    }

    public TiColumnInfo getColumn(String name) {
        return this.columnsMap.get(name.toLowerCase());
    }

    public TiColumnInfo getColumn(int offset) {
        if (offset < 0 || offset >= this.columns.size()) {
            throw new TiClientInternalException(String.format("Column offset %d out of bound", offset));
        }
        return this.columns.get(offset);
    }

    public boolean isPkHandle() {
        return this.pkIsHandle;
    }

    public List<TiIndexInfo> getIndices() {
        return this.indices;
    }

    public String getComment() {
        return this.comment;
    }

    private long getAutoIncId() {
        return this.autoIncId;
    }

    private long getMaxColumnId() {
        return this.maxColumnId;
    }

    private long getMaxIndexId() {
        return this.maxIndexId;
    }

    private long getOldSchemaId() {
        return this.oldSchemaId;
    }

    public TiPartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public TiFlashReplicaInfo getTiflashReplicaInfo() {
        return this.tiflashReplicaInfo;
    }

    TableInfo toProto() {
        return TableInfo.newBuilder().setTableId(this.getId()).addAllColumns(this.getColumns().stream().map(col -> col.toProto(this)).collect(Collectors.toList())).build();
    }

    public boolean hasPrimaryKey() {
        return this.primaryKeyColumn != null;
    }

    public TiColumnInfo getPKIsHandleColumn() {
        if (this.isPkHandle()) {
            for (TiColumnInfo col : this.getColumns()) {
                if (!col.isPrimaryKey()) continue;
                return col;
            }
        }
        return null;
    }

    private TiColumnInfo copyColumn(TiColumnInfo col) {
        DataType type = col.getType();
        TiColumnInfo.InternalTypeHolder typeHolder = type.toTypeHolder();
        typeHolder.setFlag(type.getFlag() & 0xFFFFFFFD);
        DataType newType = DataTypeFactory.of(typeHolder);
        return new TiColumnInfo(col.getId(), col.getName(), col.getOffset(), newType, col.getSchemaState(), col.getOriginDefaultValue(), col.getDefaultValue(), col.getDefaultValueBit(), col.getComment(), col.getVersion(), col.getGeneratedExprString()).copyWithoutPrimaryKey();
    }

    public TiTableInfo copyTableWithRowId() {
        if (!this.isPkHandle()) {
            ImmutableList.Builder newColumns = ImmutableList.builder();
            for (TiColumnInfo col : this.getColumns()) {
                newColumns.add(this.copyColumn(col));
            }
            newColumns.add(TiColumnInfo.getRowIdColumn(this.getColumns().size()));
            return new TiTableInfo(this.getId(), CIStr.newCIStr(this.getName()), this.getCharset(), this.getCollate(), true, (List<TiColumnInfo>)((Object)newColumns.build()), this.getIndices(), this.getComment(), this.getAutoIncId(), this.getMaxColumnId(), this.getMaxIndexId(), this.getOldSchemaId(), this.partitionInfo, null, this.getTiflashReplicaInfo(), this.version, this.updateTimestamp, this.maxShardRowIDBits, null);
        }
        return this;
    }

    public String toString() {
        return this.toProto().toString();
    }

    public boolean isPartitionEnabled() {
        if (this.partitionInfo == null) {
            return false;
        }
        return this.partitionInfo.isEnable();
    }

    public boolean hasGeneratedColumn() {
        for (TiColumnInfo col : this.getColumns()) {
            if (!col.isGeneratedColumn()) continue;
            return true;
        }
        return false;
    }

    public long getVersion() {
        return this.version;
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }
}

