/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.operation;

import java.util.Collections;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.KeyException;
import org.tikv.common.operation.ErrorHandler;
import org.tikv.common.region.RegionErrorReceiver;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.TiRegion;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.kvproto.Errorpb;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.txn.AbstractLockResolverClient;
import org.tikv.txn.Lock;
import org.tikv.txn.ResolveLockResult;
import shade.com.google.protobuf.ByteString;
import shade.io.grpc.Status;
import shade.io.grpc.StatusRuntimeException;

public class KVErrorHandler<RespT>
implements ErrorHandler<RespT> {
    private static final Logger logger = LoggerFactory.getLogger(KVErrorHandler.class);
    private static final int NO_LEADER_STORE_ID = 0;
    private final Function<RespT, Errorpb.Error> getRegionError;
    private final Function<RespT, Kvrpcpb.KeyError> getKeyError;
    private final Function<ResolveLockResult, Object> resolveLockResultCallback;
    private final RegionManager regionManager;
    private final RegionErrorReceiver recv;
    private final AbstractLockResolverClient lockResolverClient;
    private final TiRegion ctxRegion;
    private final long callerStartTS;
    private final boolean forWrite;

    public KVErrorHandler(RegionManager regionManager, RegionErrorReceiver recv, AbstractLockResolverClient lockResolverClient, TiRegion ctxRegion, Function<RespT, Errorpb.Error> getRegionError, Function<RespT, Kvrpcpb.KeyError> getKeyError, Function<ResolveLockResult, Object> resolveLockResultCallback, long callerStartTS, boolean forWrite) {
        this.ctxRegion = ctxRegion;
        this.recv = recv;
        this.lockResolverClient = lockResolverClient;
        this.regionManager = regionManager;
        this.getRegionError = getRegionError;
        this.getKeyError = getKeyError;
        this.resolveLockResultCallback = resolveLockResultCallback;
        this.callerStartTS = callerStartTS;
        this.forWrite = forWrite;
    }

    public KVErrorHandler(RegionManager regionManager, RegionErrorReceiver recv, TiRegion ctxRegion, Function<RespT, Errorpb.Error> getRegionError) {
        this.ctxRegion = ctxRegion;
        this.recv = recv;
        this.lockResolverClient = null;
        this.regionManager = regionManager;
        this.getRegionError = getRegionError;
        this.getKeyError = resp -> null;
        this.resolveLockResultCallback = resolveLock -> null;
        this.callerStartTS = 0L;
        this.forWrite = false;
    }

    private Errorpb.Error getRegionError(RespT resp) {
        if (this.getRegionError != null) {
            return this.getRegionError.apply(resp);
        }
        return null;
    }

    private void invalidateRegionStoreCache(TiRegion ctxRegion) {
        this.regionManager.invalidateRegion(ctxRegion.getId());
        this.regionManager.invalidateStore(ctxRegion.getLeader().getStoreId());
    }

    private void resolveLock(BackOffer backOffer, Lock lock) {
        if (this.lockResolverClient != null) {
            logger.warn("resolving lock");
            ResolveLockResult resolveLockResult = this.lockResolverClient.resolveLocks(backOffer, this.callerStartTS, Collections.singletonList(lock), this.forWrite);
            this.resolveLockResultCallback.apply(resolveLockResult);
            long msBeforeExpired = resolveLockResult.getMsBeforeTxnExpired();
            if (msBeforeExpired > 0L) {
                backOffer.doBackOffWithMaxSleep(BackOffFunction.BackOffFuncType.BoTxnLockFast, msBeforeExpired, new KeyException(lock.toString()));
            }
        }
    }

    @Override
    public boolean handleResponseError(BackOffer backOffer, RespT resp) {
        if (resp == null) {
            String msg = String.format("Request Failed with unknown reason for region region [%s]", this.ctxRegion);
            logger.warn(msg);
            return this.handleRequestError(backOffer, new GrpcException(msg));
        }
        Errorpb.Error error = this.getRegionError(resp);
        if (error != null) {
            if (error.hasNotLeader()) {
                BackOffFunction.BackOffFuncType backOffFuncType;
                long newStoreId = error.getNotLeader().getLeader().getStoreId();
                boolean retry = true;
                logger.warn(String.format("NotLeader Error with region id %d and store id %d, new store id %d", this.ctxRegion.getId(), this.ctxRegion.getLeader().getStoreId(), newStoreId));
                if (newStoreId != 0L) {
                    if (!this.regionManager.updateLeader(this.ctxRegion.getId(), newStoreId) || !this.recv.onNotLeader(this.regionManager.getStoreById(newStoreId))) {
                        retry = false;
                    }
                    backOffFuncType = BackOffFunction.BackOffFuncType.BoUpdateLeader;
                } else {
                    logger.info(String.format("Received zero store id, from region %d try next time", this.ctxRegion.getId()));
                    backOffFuncType = BackOffFunction.BackOffFuncType.BoRegionMiss;
                }
                backOffer.doBackOff(backOffFuncType, new GrpcException(error.toString()));
                return retry;
            }
            if (error.hasStoreNotMatch()) {
                long storeId = this.ctxRegion.getLeader().getStoreId();
                logger.warn(String.format("Store Not Match happened with region id %d, store id %d", this.ctxRegion.getId(), storeId));
                this.regionManager.invalidateStore(storeId);
                this.recv.onStoreNotMatch(this.regionManager.getStoreById(storeId));
                return true;
            }
            if (error.hasEpochNotMatch()) {
                logger.warn(String.format("Stale Epoch encountered for region [%s]", this.ctxRegion));
                this.regionManager.onRegionStale(this.ctxRegion.getId());
                return false;
            }
            if (error.hasServerIsBusy()) {
                logger.warn(String.format("Server is busy for region [%s], reason: %s", this.ctxRegion, error.getServerIsBusy().getReason()));
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoServerBusy, new StatusRuntimeException(Status.fromCode(Status.Code.UNAVAILABLE).withDescription(error.toString())));
                return true;
            }
            if (error.hasStaleCommand()) {
                logger.warn(String.format("Stale command for region [%s]", this.ctxRegion));
                return true;
            }
            if (error.hasRaftEntryTooLarge()) {
                logger.warn(String.format("Raft too large for region [%s]", this.ctxRegion));
                throw new StatusRuntimeException(Status.fromCode(Status.Code.UNAVAILABLE).withDescription(error.toString()));
            }
            if (error.hasKeyNotInRegion()) {
                ByteString invalidKey = error.getKeyNotInRegion().getKey();
                logger.error(String.format("Key not in region [%s] for key [%s], this error should not happen here.", this.ctxRegion, KeyUtils.formatBytesUTF8(invalidKey)));
                throw new StatusRuntimeException(Status.UNKNOWN.withDescription(error.toString()));
            }
            logger.warn(String.format("Unknown error %s for region [%s]", error.toString(), this.ctxRegion));
            this.invalidateRegionStoreCache(this.ctxRegion);
        }
        boolean retry = false;
        Kvrpcpb.KeyError keyError = this.getKeyError.apply(resp);
        if (keyError != null) {
            try {
                Lock lock = AbstractLockResolverClient.extractLockFromKeyErr(keyError);
                this.resolveLock(backOffer, lock);
                retry = true;
            }
            catch (KeyException e) {
                logger.warn("Unable to handle KeyExceptions other than LockException", (Throwable)e);
            }
        }
        return retry;
    }

    @Override
    public boolean handleRequestError(BackOffer backOffer, Exception e) {
        this.regionManager.onRequestFail(this.ctxRegion);
        backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoTiKVRPC, new GrpcException("send tikv request error: " + e.getMessage() + ", try next peer later", e));
        return false;
    }
}

