/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.operation.iterator;

import org.tikv.common.TiConfiguration;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.TiKVException;
import org.tikv.common.key.Key;
import org.tikv.common.operation.iterator.ScanIterator;
import org.tikv.common.region.RegionStoreClient;
import org.tikv.common.region.TiRegion;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;

public class RawScanIterator
extends ScanIterator {
    public RawScanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, ByteString endKey, int limit) {
        super(conf, builder, startKey, endKey, limit);
    }

    @Override
    TiRegion loadCurrentRegionToCache() throws GrpcException {
        TiRegion region;
        Throwable throwable;
        RegionStoreClient client;
        ConcreteBackOffer backOffer = ConcreteBackOffer.newScannerNextMaxBackOff();
        while (true) {
            client = this.builder.build(this.startKey);
            throwable = null;
            region = client.getRegion();
            if (this.limit <= 0) {
                this.currentCache = null;
                break;
            }
            try {
                this.currentCache = client.rawScan(backOffer, this.startKey, this.limit);
            }
            catch (TiKVException e) {
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                client.close();
                continue;
            }
            break;
        }
        try {
            TiRegion tiRegion = region;
            return tiRegion;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (client != null) {
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    private boolean notEndOfScan() {
        return this.limit > 0 && (!this.processingLastBatch || this.index < this.currentCache.size() && Key.toRawKey(((Kvrpcpb.KvPair)this.currentCache.get(this.index)).getKey()).compareTo(this.endKey) < 0);
    }

    boolean isCacheDrained() {
        return this.currentCache == null || this.limit <= 0 || this.index >= this.currentCache.size() || this.index == -1;
    }

    @Override
    public boolean hasNext() {
        if (this.isCacheDrained() && this.cacheLoadFails()) {
            this.endOfScan = true;
            return false;
        }
        return this.notEndOfScan();
    }

    private Kvrpcpb.KvPair getCurrent() {
        if (this.isCacheDrained()) {
            return null;
        }
        --this.limit;
        return (Kvrpcpb.KvPair)this.currentCache.get(this.index++);
    }

    @Override
    public Kvrpcpb.KvPair next() {
        Kvrpcpb.KvPair kv = this.getCurrent();
        while (this.currentCache != null && kv == null) {
            if (this.cacheLoadFails()) {
                return null;
            }
            kv = this.getCurrent();
        }
        return kv;
    }
}

