/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.operation.iterator;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.tikv.common.TiConfiguration;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.key.Key;
import org.tikv.common.region.RegionStoreClient;
import org.tikv.common.region.TiRegion;
import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;

public abstract class ScanIterator
implements Iterator<Kvrpcpb.KvPair> {
    protected final TiConfiguration conf;
    protected final RegionStoreClient.RegionStoreClientBuilder builder;
    protected List<Kvrpcpb.KvPair> currentCache;
    protected ByteString startKey;
    protected int index = -1;
    protected int limit;
    protected boolean endOfScan = false;
    protected Key endKey;
    protected boolean hasEndKey;
    protected boolean processingLastBatch = false;

    ScanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, ByteString endKey, int limit) {
        this.startKey = Objects.requireNonNull(startKey, "start key is null");
        if (startKey.isEmpty()) {
            throw new IllegalArgumentException("start key cannot be empty");
        }
        this.endKey = Key.toRawKey(Objects.requireNonNull(endKey, "end key is null"));
        this.hasEndKey = !endKey.equals(ByteString.EMPTY);
        this.limit = limit;
        this.conf = conf;
        this.builder = builder;
    }

    abstract TiRegion loadCurrentRegionToCache() throws GrpcException;

    boolean cacheLoadFails() {
        if (this.endOfScan || this.processingLastBatch) {
            return true;
        }
        if (this.startKey == null || this.startKey.isEmpty()) {
            return true;
        }
        try {
            TiRegion region = this.loadCurrentRegionToCache();
            ByteString curRegionEndKey = region.getEndKey();
            if (this.currentCache == null) {
                return true;
            }
            this.index = 0;
            Key lastKey = Key.EMPTY;
            if (this.currentCache.size() < this.conf.getScanBatchSize()) {
                this.startKey = curRegionEndKey;
                lastKey = Key.toRawKey(curRegionEndKey);
            } else {
                if (this.currentCache.size() > this.conf.getScanBatchSize()) {
                    throw new IndexOutOfBoundsException("current cache size = " + this.currentCache.size() + ", larger than " + this.conf.getScanBatchSize());
                }
                lastKey = Key.toRawKey(this.currentCache.get(this.currentCache.size() - 1).getKey());
                this.startKey = lastKey.next().toByteString();
            }
            if (this.hasEndKey && lastKey.compareTo(this.endKey) >= 0) {
                this.processingLastBatch = true;
                this.startKey = null;
            }
        }
        catch (Exception e) {
            throw new TiClientInternalException("Error scanning data from region.", e);
        }
        return false;
    }
}

