/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.parser;

import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.tikv.common.exception.UnsupportedSyntaxException;
import org.tikv.common.expression.Expression;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.parser.AstBuilder;
import org.tikv.common.parser.CaseChangingCharStream;
import org.tikv.common.parser.MySqlLexer;
import org.tikv.common.parser.MySqlParser;
import org.tikv.common.parser.MySqlParserBaseVisitor;

public class TiParser
extends MySqlParserBaseVisitor {
    private final AstBuilder astBuilder;
    private TiTableInfo tableInfo;

    public TiParser() {
        this.astBuilder = new AstBuilder();
    }

    public TiParser(TiTableInfo tblInfo) {
        this.tableInfo = tblInfo;
        this.astBuilder = new AstBuilder(this.tableInfo);
    }

    public Expression parseExpression(String command) {
        if (command.equals("")) {
            throw new UnsupportedSyntaxException("cannot parse empty command");
        }
        MySqlLexer lexer = new MySqlLexer(new CaseChangingCharStream(CharStreams.fromString(command), true));
        CommonTokenStream cmnTokStrm = new CommonTokenStream(lexer);
        MySqlParser parser = new MySqlParser(cmnTokStrm);
        try {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return (Expression)this.astBuilder.visitExpressions(parser.expressions());
        }
        catch (ParseCancellationException e) {
            cmnTokStrm.seek(0);
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            return (Expression)this.astBuilder.visitExpressions(parser.expressions());
        }
    }
}

