/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.policy;

import java.util.concurrent.Callable;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.operation.ErrorHandler;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ConcreteBackOffer;
import shade.com.google.common.collect.ImmutableSet;
import shade.io.grpc.Status;

public abstract class RetryPolicy<RespT> {
    BackOffer backOffer = ConcreteBackOffer.newCopNextMaxBackOff();
    private ErrorHandler<RespT> handler;
    private ImmutableSet<Status.Code> unrecoverableStatus = ImmutableSet.of(Status.Code.ALREADY_EXISTS, Status.Code.PERMISSION_DENIED, Status.Code.INVALID_ARGUMENT, Status.Code.NOT_FOUND, Status.Code.UNIMPLEMENTED, Status.Code.OUT_OF_RANGE, new Status.Code[]{Status.Code.UNAUTHENTICATED, Status.Code.CANCELLED});

    RetryPolicy(ErrorHandler<RespT> handler) {
        this.handler = handler;
    }

    private void rethrowNotRecoverableException(Exception e) {
        Status status = Status.fromThrowable(e);
        if (this.unrecoverableStatus.contains((Object)status.getCode())) {
            throw new GrpcException(e);
        }
    }

    public RespT callWithRetry(Callable<RespT> proc, String methodName) {
        Object result;
        while (true) {
            boolean retry;
            result = null;
            try {
                result = proc.call();
            }
            catch (Exception e) {
                this.rethrowNotRecoverableException(e);
                boolean retry2 = this.handler.handleRequestError(this.backOffer, e);
                if (retry2) continue;
            }
            if (this.handler == null || !(retry = this.handler.handleResponseError(this.backOffer, result))) break;
        }
        return result;
    }

    public static interface Builder<T> {
        public RetryPolicy<T> create(ErrorHandler<T> var1);
    }
}

