/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.predicates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.tikv.common.exception.TiExpressionException;
import org.tikv.common.expression.ColumnRef;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.LogicalBinaryExpression;
import org.tikv.common.expression.visitor.DefaultVisitor;
import org.tikv.common.expression.visitor.IndexRangeSetBuilder;
import org.tikv.common.key.CompoundKey;
import org.tikv.common.key.Key;
import org.tikv.common.key.TypedKey;
import org.tikv.common.meta.TiIndexInfo;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.predicates.IndexRange;
import shade.com.google.common.collect.ImmutableList;
import shade.com.google.common.collect.Range;

public class PredicateUtils {
    public static Expression mergeCNFExpressions(List<Expression> exprs) {
        Objects.requireNonNull(exprs, "Expression list is null");
        if (exprs.size() == 0) {
            return null;
        }
        if (exprs.size() == 1) {
            return exprs.get(0);
        }
        return LogicalBinaryExpression.and(exprs.get(0), PredicateUtils.mergeCNFExpressions(exprs.subList(1, exprs.size())));
    }

    public static Set<ColumnRef> extractColumnRefFromExpression(Expression expr) {
        HashSet<ColumnRef> columnRefs = new HashSet<ColumnRef>();
        DefaultVisitor<Void, Set<ColumnRef>> visitor = new DefaultVisitor<Void, Set<ColumnRef>>(){

            @Override
            protected Void visit(ColumnRef node, Set<ColumnRef> context) {
                context.add(node);
                return null;
            }
        };
        expr.accept(visitor, columnRefs);
        return columnRefs;
    }

    public static List<IndexRange> expressionToIndexRanges(List<Expression> pointPredicates, Optional<Expression> rangePredicate, TiTableInfo table, TiIndexInfo index) {
        Objects.requireNonNull(pointPredicates, "pointPredicates is null");
        Objects.requireNonNull(rangePredicate, "rangePredicate is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        IndexRangeSetBuilder indexRangeBuilder = new IndexRangeSetBuilder(table, index);
        if (pointPredicates.size() != 0) {
            List<Key> pointKeys = PredicateUtils.expressionToPoints(pointPredicates, table, index);
            for (Key key : pointKeys) {
                if (rangePredicate.isPresent()) {
                    Set ranges = indexRangeBuilder.buildRange(rangePredicate.get()).asRanges();
                    for (Range<TypedKey> range : ranges) {
                        builder.add(new IndexRange(key, range));
                    }
                    continue;
                }
                builder.add(new IndexRange(key, null));
            }
        } else if (rangePredicate.isPresent()) {
            Set ranges = indexRangeBuilder.buildRange(rangePredicate.get()).asRanges();
            for (Range<TypedKey> range : ranges) {
                builder.add(new IndexRange(null, range));
            }
        } else {
            builder.add(new IndexRange(null, Range.all()));
        }
        return builder.build();
    }

    private static List<Key> expressionToPoints(List<Expression> pointPredicates, TiTableInfo table, TiIndexInfo index) {
        Objects.requireNonNull(pointPredicates, "pointPredicates cannot be null");
        List<Key> resultKeys = new ArrayList<Key>();
        IndexRangeSetBuilder indexRangeBuilder = new IndexRangeSetBuilder(table, index);
        for (int i = 0; i < pointPredicates.size(); ++i) {
            Expression predicate = pointPredicates.get(i);
            try {
                Set<Range<TypedKey>> ranges = indexRangeBuilder.buildRange(predicate).asRanges();
                List<Key> points = PredicateUtils.rangesToPoint(ranges);
                resultKeys = PredicateUtils.joinKeys(resultKeys, points);
                continue;
            }
            catch (Exception e) {
                throw new TiExpressionException(String.format("Error converting access points %s", predicate), e);
            }
        }
        return resultKeys;
    }

    private static List<Key> rangesToPoint(Set<Range<TypedKey>> ranges) {
        Objects.requireNonNull(ranges, "ranges is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Range<TypedKey> range : ranges) {
            if (range.hasLowerBound() && range.hasUpperBound() && range.lowerEndpoint().equals(range.upperEndpoint())) {
                builder.add(range.lowerEndpoint());
                continue;
            }
            throw new TiExpressionException("Cannot convert range to point");
        }
        return builder.build();
    }

    private static List<Key> joinKeys(List<Key> lhsKeys, List<Key> rhsKeys) {
        Objects.requireNonNull(lhsKeys, "lhsKeys is null");
        Objects.requireNonNull(rhsKeys, "rhsKeys is null");
        if (lhsKeys.isEmpty()) {
            return rhsKeys;
        }
        if (rhsKeys.isEmpty()) {
            return lhsKeys;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Key lKey : lhsKeys) {
            for (Key rKey : rhsKeys) {
                builder.add(CompoundKey.concat(lKey, rKey));
            }
        }
        return builder.build();
    }
}

