/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.region;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.tikv.common.TiConfiguration;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.key.Key;
import org.tikv.common.util.FastByteComparisons;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.Metapb;
import shade.com.google.protobuf.ByteString;

public class TiRegion
implements Serializable {
    private final Metapb.Region meta;
    private final Kvrpcpb.IsolationLevel isolationLevel;
    private final Kvrpcpb.CommandPri commandPri;
    private Metapb.Peer leader;
    private int followerIdx = 0;
    private final boolean isReplicaRead;

    public TiRegion(Metapb.Region meta, Metapb.Peer leader, Kvrpcpb.IsolationLevel isolationLevel, Kvrpcpb.CommandPri commandPri, TiConfiguration.KVMode kvMode) {
        this(meta, leader, isolationLevel, commandPri, kvMode, false);
    }

    public TiRegion(Metapb.Region meta, Metapb.Peer leader, Kvrpcpb.IsolationLevel isolationLevel, Kvrpcpb.CommandPri commandPri, TiConfiguration.KVMode kvMode, boolean isReplicaRead) {
        Objects.requireNonNull(meta, "meta is null");
        this.meta = this.decodeRegion(meta, kvMode == TiConfiguration.KVMode.RAW);
        if (leader == null || leader.getId() == 0L) {
            if (meta.getPeersCount() == 0) {
                throw new TiClientInternalException("Empty peer list for region " + meta.getId());
            }
            this.leader = meta.getPeers(0);
        } else {
            this.leader = leader;
        }
        if (isReplicaRead && meta.getPeersCount() > 0) {
            try {
                this.getNextFollower();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isolationLevel = isolationLevel;
        this.commandPri = commandPri;
        this.isReplicaRead = isReplicaRead;
    }

    private Metapb.Region decodeRegion(Metapb.Region region, boolean isRawRegion) {
        Metapb.Region.Builder builder = Metapb.Region.newBuilder().setId(region.getId()).setRegionEpoch(region.getRegionEpoch()).addAllPeers(region.getPeersList());
        if (region.getStartKey().isEmpty() || isRawRegion) {
            builder.setStartKey(region.getStartKey());
        } else {
            byte[] decodedStartKey = Codec.BytesCodec.readBytes(new CodecDataInput(region.getStartKey()));
            builder.setStartKey(ByteString.copyFrom(decodedStartKey));
        }
        if (region.getEndKey().isEmpty() || isRawRegion) {
            builder.setEndKey(region.getEndKey());
        } else {
            byte[] decodedEndKey = Codec.BytesCodec.readBytes(new CodecDataInput(region.getEndKey()));
            builder.setEndKey(ByteString.copyFrom(decodedEndKey));
        }
        return builder.build();
    }

    public Metapb.Peer getLeader() {
        return this.leader;
    }

    public Metapb.Peer getCurrentFollower() {
        return this.meta.getPeers(this.followerIdx);
    }

    public Metapb.Peer getNextFollower() {
        int cnt = this.meta.getPeersCount();
        for (int retry = cnt - 1; retry > 0; --retry) {
            this.followerIdx = (this.followerIdx + 1) % cnt;
            Metapb.Peer cur = this.meta.getPeers(this.followerIdx);
            if (cur.getIsLearner()) continue;
            return cur;
        }
        return this.leader;
    }

    public List<Metapb.Peer> getLearnerList() {
        ArrayList<Metapb.Peer> peers = new ArrayList<Metapb.Peer>();
        for (Metapb.Peer peer : this.getMeta().getPeersList()) {
            if (!peer.getIsLearner()) continue;
            peers.add(peer);
        }
        return peers;
    }

    public long getId() {
        return this.meta.getId();
    }

    public ByteString getStartKey() {
        return this.meta.getStartKey();
    }

    public boolean contains(Key key) {
        return KeyRangeUtils.makeRange(this.getStartKey(), this.getEndKey()).contains(key);
    }

    public ByteString getEndKey() {
        return this.meta.getEndKey();
    }

    public Key getRowEndKey() {
        return Key.toRawKey(this.getEndKey());
    }

    public Kvrpcpb.Context getContext() {
        return this.getContext(Collections.emptySet());
    }

    public Kvrpcpb.Context getContext(Set<Long> resolvedLocks) {
        Kvrpcpb.Context.Builder builder = Kvrpcpb.Context.newBuilder();
        builder.setIsolationLevel(this.isolationLevel);
        builder.setPriority(this.commandPri);
        if (this.isReplicaRead) {
            builder.setRegionId(this.meta.getId()).setPeer(this.getCurrentFollower()).setReplicaRead(true).setRegionEpoch(this.meta.getRegionEpoch());
        } else {
            builder.setRegionId(this.meta.getId()).setPeer(this.leader).setRegionEpoch(this.meta.getRegionEpoch());
        }
        builder.addAllResolvedLocks(resolvedLocks);
        return builder.build();
    }

    public RegionVerID getVerID() {
        return new RegionVerID(this.meta.getId(), this.meta.getRegionEpoch().getConfVer(), this.meta.getRegionEpoch().getVersion());
    }

    boolean switchPeer(long leaderStoreID) {
        List<Metapb.Peer> peers = this.meta.getPeersList();
        for (Metapb.Peer p : peers) {
            if (p.getStoreId() != leaderStoreID) continue;
            this.leader = p;
            return true;
        }
        return false;
    }

    public boolean isMoreThan(ByteString key) {
        return FastByteComparisons.compareTo(this.meta.getStartKey().toByteArray(), 0, this.meta.getStartKey().size(), key.toByteArray(), 0, key.size()) > 0;
    }

    public boolean isLessThan(ByteString key) {
        return FastByteComparisons.compareTo(this.meta.getEndKey().toByteArray(), 0, this.meta.getEndKey().size(), key.toByteArray(), 0, key.size()) <= 0;
    }

    public boolean contains(ByteString key) {
        return !this.isMoreThan(key) && !this.isLessThan(key);
    }

    public boolean isValid() {
        return this.leader != null && this.meta != null;
    }

    public Metapb.RegionEpoch getRegionEpoch() {
        return this.meta.getRegionEpoch();
    }

    public Metapb.Region getMeta() {
        return this.meta;
    }

    public boolean equals(Object another) {
        if (!(another instanceof TiRegion)) {
            return false;
        }
        TiRegion anotherRegion = (TiRegion)another;
        return anotherRegion.meta.equals(this.meta) && anotherRegion.leader.equals(this.leader) && anotherRegion.commandPri.equals(this.commandPri) && anotherRegion.isolationLevel.equals(this.isolationLevel);
    }

    public int hashCode() {
        return Objects.hash(this.meta, this.leader, this.isolationLevel, this.commandPri);
    }

    public String toString() {
        return String.format("{Region[%d] ConfVer[%d] Version[%d] Store[%d] KeyRange[%s]:[%s]}", this.getId(), this.getRegionEpoch().getConfVer(), this.getRegionEpoch().getVersion(), this.getLeader().getStoreId(), KeyUtils.formatBytesUTF8(this.getStartKey()), KeyUtils.formatBytesUTF8(this.getEndKey()));
    }

    public class RegionVerID {
        final long id;
        final long confVer;
        final long ver;

        RegionVerID(long id, long confVer, long ver) {
            this.id = id;
            this.confVer = confVer;
            this.ver = ver;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegionVerID)) {
                return false;
            }
            RegionVerID that = (RegionVerID)other;
            return this.id == that.id && this.confVer == that.confVer && this.ver == that.ver;
        }

        public int hashCode() {
            int hash = Long.hashCode(this.id);
            hash = hash * 31 + Long.hashCode(this.confVer);
            hash = hash * 31 + Long.hashCode(this.ver);
            return hash;
        }
    }
}

