/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Map;
import org.tikv.common.exception.TypeException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.BitType;
import org.tikv.common.types.BytesType;
import org.tikv.common.types.DataType;
import org.tikv.common.types.DateTimeType;
import org.tikv.common.types.DateType;
import org.tikv.common.types.DecimalType;
import org.tikv.common.types.EnumType;
import org.tikv.common.types.IntegerType;
import org.tikv.common.types.JsonType;
import org.tikv.common.types.MySQLType;
import org.tikv.common.types.RealType;
import org.tikv.common.types.SetType;
import org.tikv.common.types.StringType;
import org.tikv.common.types.TimeType;
import org.tikv.common.types.TimestampType;
import org.tikv.common.types.UninitializedType;
import shade.com.google.common.collect.ImmutableMap;

public class DataTypeFactory {
    private static final Map<MySQLType, Constructor<? extends DataType>> dataTypeCreatorMap;
    private static final Map<MySQLType, DataType> dataTypeInstanceMap;

    private static void extractTypeMap(MySQLType[] types, Class<? extends DataType> cls, ImmutableMap.Builder<MySQLType, Constructor<? extends DataType>> holderBuilder, ImmutableMap.Builder<MySQLType, DataType> instBuilder) {
        for (MySQLType type : types) {
            try {
                Constructor<? extends DataType> ctorByHolder = cls.getDeclaredConstructor(TiColumnInfo.InternalTypeHolder.class);
                Constructor<? extends DataType> ctorByType = cls.getDeclaredConstructor(MySQLType.class);
                ctorByHolder.setAccessible(true);
                ctorByType.setAccessible(true);
                holderBuilder.put(type, ctorByHolder);
                instBuilder.put(type, ctorByType.newInstance(new Object[]{type}));
            }
            catch (Exception e) {
                throw new TypeException(String.format("Type %s does not have a proper constructor", cls.getName()), e);
            }
        }
    }

    public static DataType of(MySQLType type) {
        DataType dataType = dataTypeInstanceMap.get((Object)type);
        if (dataType == null) {
            throw new TypeException("Type not found for " + (Object)((Object)type));
        }
        return dataType;
    }

    private static MySQLType convertType(MySQLType type, TiColumnInfo.InternalTypeHolder holder) {
        if (Arrays.asList(BytesType.subTypes).contains((Object)type) && !"binary".equals(holder.getCharset())) {
            return MySQLType.TypeVarchar;
        }
        if (Arrays.asList(StringType.subTypes).contains((Object)type) && "binary".equals(holder.getCharset())) {
            return MySQLType.TypeBlob;
        }
        return type;
    }

    public static DataType of(TiColumnInfo.InternalTypeHolder holder) {
        MySQLType type = MySQLType.fromTypeCode(holder.getTp());
        Constructor<? extends DataType> ctor = dataTypeCreatorMap.get((Object)(type = DataTypeFactory.convertType(type, holder)));
        if (ctor == null) {
            throw new NullPointerException("tp " + holder.getTp() + " passed in can not retrieved DataType info.");
        }
        try {
            return ctor.newInstance(holder);
        }
        catch (Exception e) {
            throw new TypeException("Cannot create type from " + holder.getTp(), e);
        }
    }

    static {
        ImmutableMap.Builder<MySQLType, Constructor<? extends DataType>> builder = ImmutableMap.builder();
        ImmutableMap.Builder<MySQLType, DataType> instBuilder = ImmutableMap.builder();
        DataTypeFactory.extractTypeMap(BitType.subTypes, BitType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(StringType.subTypes, StringType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(DateTimeType.subTypes, DateTimeType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(DateType.subTypes, DateType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(DecimalType.subTypes, DecimalType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(IntegerType.subTypes, IntegerType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(BytesType.subTypes, BytesType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(RealType.subTypes, RealType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(TimestampType.subTypes, TimestampType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(EnumType.subTypes, EnumType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(SetType.subTypes, SetType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(JsonType.subTypes, JsonType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(TimeType.subTypes, TimeType.class, builder, instBuilder);
        DataTypeFactory.extractTypeMap(UninitializedType.subTypes, UninitializedType.class, builder, instBuilder);
        dataTypeCreatorMap = builder.build();
        dataTypeInstanceMap = instBuilder.build();
    }
}

