/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.util;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import shade.com.google.common.primitives.UnsignedBytes;
import sun.misc.Unsafe;

public abstract class FastByteComparisons {
    public static int compareTo(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(b1, s1, l1, b2, s2, l2);
    }

    public static int compareTo(byte[] b1, byte[] b2) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(b1, 0, b1.length, b2, 0, b2.length);
    }

    private static Comparer<byte[]> lexicographicalComparerJavaImpl() {
        return LexicographicalComparerHolder.PureJavaComparer.INSTANCE;
    }

    private static class LexicographicalComparerHolder {
        static final String UNSAFE_COMPARER_NAME = LexicographicalComparerHolder.class.getName() + "$UnsafeComparer";
        static final Comparer<byte[]> BEST_COMPARER = LexicographicalComparerHolder.getBestComparer();

        private LexicographicalComparerHolder() {
        }

        static Comparer<byte[]> getBestComparer() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                Comparer comparer = (Comparer)theClass.getEnumConstants()[0];
                return comparer;
            }
            catch (Throwable t) {
                return FastByteComparisons.lexicographicalComparerJavaImpl();
            }
        }

        private static enum UnsafeComparer implements Comparer<byte[]>
        {
            INSTANCE;

            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;
            static final boolean littleEndian;

            static boolean lessThanUnsigned(long x1, long x2) {
                return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
            }

            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                int i;
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int minLength = Math.min(length1, length2);
                int minWords = minLength / 8;
                int offset1Adj = offset1 + BYTE_ARRAY_BASE_OFFSET;
                int offset2Adj = offset2 + BYTE_ARRAY_BASE_OFFSET;
                for (i = 0; i < minWords * 8; i += 8) {
                    int y;
                    long rw;
                    long lw = theUnsafe.getLong(buffer1, (long)offset1Adj + (long)i);
                    long diff = lw ^ (rw = theUnsafe.getLong(buffer2, (long)offset2Adj + (long)i));
                    if (diff == 0L) continue;
                    if (!littleEndian) {
                        return UnsafeComparer.lessThanUnsigned(lw, rw) ? -1 : 1;
                    }
                    int n = 0;
                    int x = (int)diff;
                    if (x == 0) {
                        x = (int)(diff >>> 32);
                        n = 32;
                    }
                    if ((y = x << 16) == 0) {
                        n += 16;
                    } else {
                        x = y;
                    }
                    y = x << 8;
                    if (y == 0) {
                        n += 8;
                    }
                    return (int)((lw >>> n & 0xFFL) - (rw >>> n & 0xFFL));
                }
                for (i = minWords * 8; i < minLength; ++i) {
                    int result = UnsignedBytes.compare(buffer1[offset1 + i], buffer2[offset2 + i]);
                    if (result == 0) continue;
                    return result;
                }
                return length1 - length2;
            }

            static {
                theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Field f = Unsafe.class.getDeclaredField("theUnsafe");
                            f.setAccessible(true);
                            return f.get(null);
                        }
                        catch (NoSuchFieldException e) {
                            throw new Error();
                        }
                        catch (IllegalAccessException e) {
                            throw new Error();
                        }
                    }
                });
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
                littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
            }
        }

        private static enum PureJavaComparer implements Comparer<byte[]>
        {
            INSTANCE;


            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int end1 = offset1 + length1;
                int end2 = offset2 + length2;
                int i = offset1;
                for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                    int a = buffer1[i] & 0xFF;
                    int b = buffer2[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return length1 - length2;
            }
        }
    }

    private static interface Comparer<T> {
        public int compareTo(T var1, int var2, int var3, T var4, int var5, int var6);
    }
}

