/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.util;

import java.util.List;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.key.Key;
import org.tikv.kvproto.Coprocessor;
import shade.com.google.common.collect.BoundType;
import shade.com.google.common.collect.ImmutableList;
import shade.com.google.common.collect.Range;
import shade.com.google.protobuf.ByteString;

public class KeyRangeUtils {
    public static Range<Key> makeRange(ByteString startKey, ByteString endKey) {
        return Range.closedOpen(Key.toRawKey(startKey, true), Key.toRawKey(endKey));
    }

    public static Coprocessor.KeyRange makeCoprocRange(ByteString startKey, ByteString endKey) {
        return Coprocessor.KeyRange.newBuilder().setStart(startKey).setEnd(endKey).build();
    }

    public static Coprocessor.KeyRange makeCoprocRange(Range<Key> range) {
        if (!range.hasLowerBound() || !range.hasUpperBound()) {
            throw new TiClientInternalException("range is not bounded");
        }
        if (range.lowerBoundType().equals((Object)BoundType.OPEN) || range.upperBoundType().equals((Object)BoundType.CLOSED)) {
            throw new TiClientInternalException("range must be CLOSED_OPEN");
        }
        return KeyRangeUtils.makeCoprocRange(range.lowerEndpoint().toByteString(), range.upperEndpoint().toByteString());
    }

    public static List<Coprocessor.KeyRange> mergeRanges(List<Coprocessor.KeyRange> ranges) {
        if (ranges == null || ranges.isEmpty() || ranges.size() == 1) {
            return ranges;
        }
        Coprocessor.KeyRange first = ranges.get(0);
        Key lowMin = Key.toRawKey(first.getStart(), true);
        Key upperMax = Key.toRawKey(first.getEnd(), false);
        for (int i = 1; i < ranges.size(); ++i) {
            Coprocessor.KeyRange keyRange = ranges.get(i);
            Key start = Key.toRawKey(keyRange.getStart(), true);
            Key end = Key.toRawKey(keyRange.getEnd(), false);
            if (start.compareTo(lowMin) < 0) {
                lowMin = start;
            }
            if (end.compareTo(upperMax) <= 0) continue;
            upperMax = end;
        }
        ImmutableList.Builder rangeBuilder = ImmutableList.builder();
        rangeBuilder.add(KeyRangeUtils.makeCoprocRange(lowMin.toByteString(), upperMax.toByteString()));
        return rangeBuilder.build();
    }

    public static List<Coprocessor.KeyRange> mergeSortedRanges(List<Coprocessor.KeyRange> ranges) {
        return KeyRangeUtils.mergeSortedRanges(ranges, 1);
    }

    public static List<Coprocessor.KeyRange> mergeSortedRanges(List<Coprocessor.KeyRange> ranges, int splitNum) {
        if (splitNum <= 0) {
            throw new RuntimeException("Cannot split ranges by non-positive integer");
        }
        if (ranges == null || ranges.isEmpty() || ranges.size() <= splitNum) {
            return ranges;
        }
        int step = (ranges.size() + splitNum - 1) / splitNum;
        ImmutableList.Builder rangeBuilder = ImmutableList.builder();
        int nowPos = 0;
        for (int i = 0; i < splitNum; ++i) {
            int nextPos = Math.min(nowPos + step - 1, ranges.size() - 1);
            Coprocessor.KeyRange first = ranges.get(nowPos);
            Coprocessor.KeyRange last = ranges.get(nextPos);
            Key lowerMin = Key.toRawKey(first.getStart(), true);
            Key upperMax = Key.toRawKey(last.getEnd(), false);
            rangeBuilder.add(KeyRangeUtils.makeCoprocRange(lowerMin.toByteString(), upperMax.toByteString()));
            nowPos += step;
        }
        return rangeBuilder.build();
    }

    static String formatByteString(ByteString key) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < key.size(); ++i) {
            sb.append(key.byteAt(i) & 0xFF);
            if (i >= key.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

