/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.txn;

import java.util.List;
import org.tikv.common.PDClient;
import org.tikv.common.StoreVersion;
import org.tikv.common.TiConfiguration;
import org.tikv.common.exception.KeyException;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.RegionStoreClient;
import org.tikv.common.region.TiRegion;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ChannelFactory;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.TikvGrpc;
import org.tikv.txn.Lock;
import org.tikv.txn.LockResolverClientV2;
import org.tikv.txn.LockResolverClientV3;
import org.tikv.txn.LockResolverClientV4;
import org.tikv.txn.ResolveLockResult;

public interface AbstractLockResolverClient {
    public static final long RESOLVED_TXN_CACHE_SIZE = 2048L;
    public static final long BIG_TXN_THRESHOLD = 16L;

    public static Lock extractLockFromKeyErr(Kvrpcpb.KeyError keyError) {
        if (keyError.hasLocked()) {
            return new Lock(keyError.getLocked());
        }
        if (keyError.hasConflict()) {
            Kvrpcpb.WriteConflict conflict = keyError.getConflict();
            throw new KeyException(String.format("scan meet key conflict on primary key %s at commit ts %s", conflict.getPrimary(), conflict.getConflictTs()));
        }
        if (!keyError.getRetryable().isEmpty()) {
            throw new KeyException(String.format("tikv restart txn %s", keyError.getRetryableBytes().toStringUtf8()));
        }
        if (!keyError.getAbort().isEmpty()) {
            throw new KeyException(String.format("tikv abort txn %s", keyError.getAbortBytes().toStringUtf8()));
        }
        throw new KeyException(String.format("unexpected key error meets and it is %s", keyError.toString()));
    }

    public static AbstractLockResolverClient getInstance(String storeVersion, TiConfiguration conf, TiRegion region, TikvGrpc.TikvBlockingStub blockingStub, TikvGrpc.TikvStub asyncStub, ChannelFactory channelFactory, RegionManager regionManager, PDClient pdClient, RegionStoreClient.RegionStoreClientBuilder clientBuilder) {
        if (StoreVersion.compareTo(storeVersion, "3.0.5") < 0) {
            return new LockResolverClientV2(conf, region, blockingStub, asyncStub, channelFactory, regionManager);
        }
        if (StoreVersion.compareTo(storeVersion, "4.0.0") < 0) {
            return new LockResolverClientV3(conf, region, blockingStub, asyncStub, channelFactory, regionManager, pdClient, clientBuilder);
        }
        return new LockResolverClientV4(conf, region, blockingStub, asyncStub, channelFactory, regionManager, pdClient, clientBuilder);
    }

    public String getVersion();

    public ResolveLockResult resolveLocks(BackOffer var1, long var2, List<Lock> var4, boolean var5);
}

