/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.txn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.PDClient;
import org.tikv.common.TiConfiguration;
import org.tikv.common.exception.KeyException;
import org.tikv.common.exception.RegionException;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.operation.KVErrorHandler;
import org.tikv.common.region.AbstractRegionStoreClient;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.RegionStoreClient;
import org.tikv.common.region.TiRegion;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ChannelFactory;
import org.tikv.common.util.TsoUtils;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.TikvGrpc;
import org.tikv.txn.AbstractLockResolverClient;
import org.tikv.txn.Lock;
import org.tikv.txn.ResolveLockResult;
import org.tikv.txn.TxnExpireTime;
import org.tikv.txn.TxnStatus;
import shade.com.google.protobuf.ByteString;

public class LockResolverClientV3
extends AbstractRegionStoreClient
implements AbstractLockResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(LockResolverClientV3.class);
    private final ReadWriteLock readWriteLock;
    private final Map<Long, TxnStatus> resolved = new HashMap<Long, TxnStatus>();
    private final Queue<Long> recentResolved = new LinkedList<Long>();
    private final PDClient pdClient;
    private final RegionStoreClient.RegionStoreClientBuilder clientBuilder;

    public LockResolverClientV3(TiConfiguration conf, TiRegion region, TikvGrpc.TikvBlockingStub blockingStub, TikvGrpc.TikvStub asyncStub, ChannelFactory channelFactory, RegionManager regionManager, PDClient pdClient, RegionStoreClient.RegionStoreClientBuilder clientBuilder) {
        super(conf, region, channelFactory, blockingStub, asyncStub, regionManager);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.pdClient = pdClient;
        this.clientBuilder = clientBuilder;
    }

    @Override
    public String getVersion() {
        return "V3";
    }

    @Override
    public ResolveLockResult resolveLocks(BackOffer bo, long callerStartTS, List<Lock> locks, boolean forWrite) {
        TxnExpireTime msBeforeTxnExpired = new TxnExpireTime();
        if (locks.isEmpty()) {
            return new ResolveLockResult(msBeforeTxnExpired.value());
        }
        ArrayList<Lock> expiredLocks = new ArrayList<Lock>();
        for (Lock lock : locks) {
            if (TsoUtils.isExpired(lock.getTxnID(), lock.getTtl())) {
                expiredLocks.add(lock);
                continue;
            }
            msBeforeTxnExpired.update(lock.getTtl());
        }
        if (expiredLocks.isEmpty()) {
            return new ResolveLockResult(msBeforeTxnExpired.value());
        }
        HashMap<Long, Set> cleanTxns = new HashMap<Long, Set>();
        for (Lock l : expiredLocks) {
            TxnStatus status = this.getTxnStatusFromLock(bo, l);
            if (status.getTtl() == 0L) {
                Set cleanRegion = cleanTxns.computeIfAbsent(l.getTxnID(), k -> new HashSet());
                this.resolveLock(bo, l, status, cleanRegion);
                continue;
            }
            long msBeforeLockExpired = TsoUtils.untilExpired(l.getTxnID(), status.getTtl());
            msBeforeTxnExpired.update(msBeforeLockExpired);
        }
        return new ResolveLockResult(msBeforeTxnExpired.value());
    }

    private void resolveLock(BackOffer bo, Lock lock, TxnStatus txnStatus, Set<TiRegion.RegionVerID> cleanRegion) {
        Kvrpcpb.ResolveLockResponse resp2;
        boolean cleanWholeRegion = lock.getTxnSize() >= 16L;
        while (true) {
            this.region = this.regionManager.getRegionByKey(lock.getKey());
            if (cleanRegion.contains(this.region.getVerID())) {
                return;
            }
            Kvrpcpb.ResolveLockRequest.Builder builder = Kvrpcpb.ResolveLockRequest.newBuilder().setContext(this.region.getContext()).setStartVersion(lock.getTxnID());
            if (txnStatus.isCommitted()) {
                builder.setCommitVersion(txnStatus.getCommitTS());
            }
            if (lock.getTxnSize() < 16L) {
                builder.addKeys(lock.getKey());
            }
            Supplier<Kvrpcpb.ResolveLockRequest> factory = builder::build;
            KVErrorHandler<Kvrpcpb.ResolveLockResponse> handler = new KVErrorHandler<Kvrpcpb.ResolveLockResponse>(this.regionManager, this, this, this.region, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> null, 0L, false);
            resp2 = this.callWithRetry(bo, TikvGrpc.getKvResolveLockMethod(), factory, handler);
            if (resp2 == null) {
                logger.error("getKvResolveLockMethod failed without a cause");
                this.regionManager.onRequestFail(this.region);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKvResolveLockMethod failed without a cause"));
                continue;
            }
            if (!resp2.hasRegionError()) break;
            bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp2.getRegionError()));
        }
        if (resp2.hasError()) {
            logger.error(String.format("unexpected resolveLock err: %s, lock: %s", resp2.getError(), lock));
            throw new KeyException(resp2.getError());
        }
        if (cleanWholeRegion) {
            cleanRegion.add(this.region.getVerID());
        }
    }

    private TxnStatus getTxnStatusFromLock(BackOffer bo, Lock lock) {
        if (lock.getTtl() == 0L) {
            return this.getTxnStatus(bo, lock.getTxnID(), lock.getPrimary(), 0L);
        }
        long currentTS = this.pdClient.getTimestamp(bo).getVersion();
        return this.getTxnStatus(bo, lock.getTxnID(), lock.getPrimary(), currentTS);
    }

    private TxnStatus getTxnStatus(BackOffer bo, Long txnID, ByteString primary, Long currentTS) {
        Kvrpcpb.CleanupResponse resp2;
        TxnStatus status = this.getResolved(txnID);
        if (status != null) {
            return status;
        }
        Supplier<Kvrpcpb.CleanupRequest> factory = () -> {
            TiRegion primaryKeyRegion = this.regionManager.getRegionByKey(primary);
            return Kvrpcpb.CleanupRequest.newBuilder().setContext(primaryKeyRegion.getContext()).setKey(primary).setStartVersion(txnID).setCurrentTs(currentTS).build();
        };
        status = new TxnStatus();
        while (true) {
            TiRegion primaryKeyRegion = this.regionManager.getRegionByKey(primary);
            RegionStoreClient primaryKeyRegionStoreClient = this.clientBuilder.build(primary);
            KVErrorHandler<Kvrpcpb.CleanupResponse> handler = new KVErrorHandler<Kvrpcpb.CleanupResponse>(this.regionManager, primaryKeyRegionStoreClient, primaryKeyRegionStoreClient.lockResolverClient, primaryKeyRegion, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> null, 0L, false);
            resp2 = primaryKeyRegionStoreClient.callWithRetry(bo, TikvGrpc.getKvCleanupMethod(), factory, handler);
            if (resp2 == null) {
                logger.error("getKvCleanupMethod failed without a cause");
                this.regionManager.onRequestFail(primaryKeyRegion);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKvCleanupMethod failed without a cause"));
                continue;
            }
            if (!resp2.hasRegionError()) break;
            bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp2.getRegionError()));
        }
        if (resp2.hasError()) {
            Kvrpcpb.KeyError keyError = resp2.getError();
            if (keyError.hasLocked()) {
                Kvrpcpb.LockInfo lockInfo = keyError.getLocked();
                return new TxnStatus(lockInfo.getLockTtl(), 0L);
            }
            logger.error(String.format("unexpected cleanup err: %s, tid: %d", keyError, txnID));
            throw new KeyException(keyError);
        }
        if (resp2.getCommitVersion() != 0L) {
            status = new TxnStatus(0L, resp2.getCommitVersion());
        }
        this.saveResolved(txnID, status);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResolved(long txnID, TxnStatus status) {
        try {
            this.readWriteLock.writeLock().lock();
            if (this.resolved.containsKey(txnID)) {
                return;
            }
            this.resolved.put(txnID, status);
            this.recentResolved.add(txnID);
            if ((long)this.recentResolved.size() > 2048L) {
                Long front = this.recentResolved.remove();
                this.resolved.remove(front);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private TxnStatus getResolved(Long txnID) {
        try {
            this.readWriteLock.readLock().lock();
            TxnStatus txnStatus = this.resolved.get(txnID);
            return txnStatus;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

