/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.txn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.ReadOnlyPDClient;
import org.tikv.common.TiConfiguration;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.KeyException;
import org.tikv.common.exception.RegionException;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.exception.TiKVException;
import org.tikv.common.meta.TiTimestamp;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.RegionStoreClient;
import org.tikv.common.region.TiRegion;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.Metapb;
import org.tikv.txn.type.ClientRPCResult;
import shade.com.google.common.collect.Lists;
import shade.com.google.protobuf.ByteString;
import shade.io.grpc.StatusRuntimeException;

public class TxnKVClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TxnKVClient.class);
    private final RegionStoreClient.RegionStoreClientBuilder clientBuilder;
    private final TiConfiguration conf;
    private final RegionManager regionManager;
    private final ReadOnlyPDClient pdClient;

    public TxnKVClient(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder clientBuilder, ReadOnlyPDClient pdClient) {
        this.conf = conf;
        this.clientBuilder = clientBuilder;
        this.regionManager = clientBuilder.getRegionManager();
        this.pdClient = pdClient;
    }

    public TiConfiguration getConf() {
        return this.conf;
    }

    public RegionManager getRegionManager() {
        return this.regionManager;
    }

    public TiTimestamp getTimestamp() {
        ConcreteBackOffer bo = ConcreteBackOffer.newTsoBackOff();
        TiTimestamp timestamp = new TiTimestamp(0L, 0L);
        try {
            while (true) {
                try {
                    timestamp = this.pdClient.getTimestamp(bo);
                }
                catch (TiKVException e) {
                    bo.doBackOff(BackOffFunction.BackOffFuncType.BoPDRPC, e);
                    continue;
                }
                break;
            }
        }
        catch (GrpcException e1) {
            LOG.error("Get tso from pd failed,", (Throwable)e1);
        }
        return timestamp;
    }

    public ClientRPCResult prewrite(BackOffer backOffer, List<Kvrpcpb.Mutation> mutations, ByteString primary, long lockTTL, long startTs, TiRegion tiRegion, Metapb.Store store) {
        ClientRPCResult result = new ClientRPCResult(true, false, null);
        RegionStoreClient client = this.clientBuilder.build(tiRegion, store);
        try {
            client.prewrite(backOffer, primary, mutations, startTs, lockTTL);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setRetry(this.retryableException(e));
            result.setException(e);
        }
        return result;
    }

    public ClientRPCResult txnHeartBeat(BackOffer backOffer, ByteString primaryLock, long startTs, long ttl, TiRegion tiRegion, Metapb.Store store) {
        ClientRPCResult result = new ClientRPCResult(true, false, null);
        RegionStoreClient client = this.clientBuilder.build(tiRegion, store);
        try {
            client.txnHeartBeat(backOffer, primaryLock, startTs, ttl);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setRetry(this.retryableException(e));
            result.setException(e);
        }
        return result;
    }

    public ClientRPCResult commit(BackOffer backOffer, ByteString[] keys, long startTs, long commitTs, TiRegion tiRegion, Metapb.Store store) {
        ClientRPCResult result = new ClientRPCResult(true, false, null);
        RegionStoreClient client = this.clientBuilder.build(tiRegion, store);
        ArrayList<ByteString> byteList = Lists.newArrayList();
        byteList.addAll(Arrays.asList(keys));
        try {
            client.commit(backOffer, byteList, startTs, commitTs);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setRetry(this.retryableException(e));
            result.setException(e);
        }
        return result;
    }

    private boolean retryableException(Exception e) {
        return e instanceof TiClientInternalException || e instanceof KeyException || e instanceof RegionException || e instanceof StatusRuntimeException;
    }

    @Override
    public void close() throws Exception {
    }
}

