/*
 * Decompiled with CFR 0.152.
 */
package shade.com.google.common.cache;

import java.util.concurrent.Executor;
import shade.com.google.common.annotations.GwtIncompatible;
import shade.com.google.common.base.Preconditions;
import shade.com.google.common.cache.RemovalListener;
import shade.com.google.common.cache.RemovalNotification;

@GwtIncompatible
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

