/*
 * Decompiled with CFR 0.152.
 */
package shade.io.grpc.internal;

import java.util.concurrent.Executor;
import shade.com.google.common.annotations.VisibleForTesting;
import shade.com.google.common.base.Preconditions;
import shade.com.google.common.util.concurrent.ListenableFuture;
import shade.com.google.common.util.concurrent.SettableFuture;
import shade.io.grpc.CallOptions;
import shade.io.grpc.InternalChannelz;
import shade.io.grpc.InternalLogId;
import shade.io.grpc.Metadata;
import shade.io.grpc.MethodDescriptor;
import shade.io.grpc.Status;
import shade.io.grpc.internal.ClientStream;
import shade.io.grpc.internal.ClientStreamListener;
import shade.io.grpc.internal.ClientTransport;
import shade.io.grpc.internal.FailingClientStream;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
        return new FailingClientStream(this.error, this.rpcProgress);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

