/*
 * Decompiled with CFR 0.152.
 */
package shade.io.grpc.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import shade.com.google.common.annotations.VisibleForTesting;
import shade.com.google.common.base.Preconditions;
import shade.io.grpc.CallOptions;
import shade.io.grpc.Channel;
import shade.io.grpc.ClientCall;
import shade.io.grpc.Context;
import shade.io.grpc.LoadBalancer;
import shade.io.grpc.Metadata;
import shade.io.grpc.MethodDescriptor;
import shade.io.grpc.Status;
import shade.io.grpc.internal.CallTracer;
import shade.io.grpc.internal.ClientCallImpl;
import shade.io.grpc.internal.ClientStream;
import shade.io.grpc.internal.ClientStreamListener;
import shade.io.grpc.internal.ClientTransport;
import shade.io.grpc.internal.FailingClientTransport;
import shade.io.grpc.internal.GrpcUtil;
import shade.io.grpc.internal.InternalSubchannel;

final class SubchannelChannel
extends Channel {
    @VisibleForTesting
    static final Status NOT_READY_ERROR = Status.UNAVAILABLE.withDescription("Subchannel is NOT READY");
    @VisibleForTesting
    static final Status WAIT_FOR_READY_ERROR = Status.UNAVAILABLE.withDescription("wait-for-ready RPC is not supported on Subchannel.asChannel()");
    private static final FailingClientTransport notReadyTransport = new FailingClientTransport(NOT_READY_ERROR, ClientStreamListener.RpcProgress.REFUSED);
    private final InternalSubchannel subchannel;
    private final Executor executor;
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private final CallTracer callsTracer;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        @Override
        public ClientTransport get(LoadBalancer.PickSubchannelArgs args) {
            ClientTransport transport = SubchannelChannel.this.subchannel.getTransport();
            if (transport == null) {
                return notReadyTransport;
            }
            return transport;
        }

        @Override
        public <ReqT> ClientStream newRetriableStream(MethodDescriptor<ReqT, ?> method, CallOptions callOptions, Metadata headers, Context context) {
            throw new UnsupportedOperationException("OobChannel should not create retriable streams");
        }
    };

    SubchannelChannel(InternalSubchannel subchannel, Executor executor, ScheduledExecutorService deadlineCancellationExecutor, CallTracer callsTracer) {
        this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
        this.executor = Preconditions.checkNotNull(executor, "executor");
        this.deadlineCancellationExecutor = Preconditions.checkNotNull(deadlineCancellationExecutor, "deadlineCancellationExecutor");
        this.callsTracer = Preconditions.checkNotNull(callsTracer, "callsTracer");
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        Executor effectiveExecutor;
        Executor executor = effectiveExecutor = callOptions.getExecutor() == null ? this.executor : callOptions.getExecutor();
        if (callOptions.isWaitForReady()) {
            return new ClientCall<RequestT, ResponseT>(){

                @Override
                public void start(final ClientCall.Listener<ResponseT> listener, Metadata headers) {
                    effectiveExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.onClose(WAIT_FOR_READY_ERROR, new Metadata());
                        }
                    });
                }

                @Override
                public void request(int numMessages) {
                }

                @Override
                public void cancel(String message, Throwable cause) {
                }

                @Override
                public void halfClose() {
                }

                @Override
                public void sendMessage(RequestT message) {
                }
            };
        }
        return new ClientCallImpl<RequestT, ResponseT>(methodDescriptor, effectiveExecutor, callOptions.withOption(GrpcUtil.CALL_OPTIONS_RPC_OWNED_BY_BALANCER, Boolean.TRUE), this.transportProvider, this.deadlineCancellationExecutor, this.callsTracer, false);
    }

    @Override
    public String authority() {
        return this.subchannel.getAuthority();
    }
}

