/*
 * Decompiled with CFR 0.152.
 */
package shade.io.netty.handler.codec.base64;

import java.util.List;
import shade.io.netty.buffer.ByteBuf;
import shade.io.netty.channel.ChannelHandler;
import shade.io.netty.channel.ChannelHandlerContext;
import shade.io.netty.handler.codec.MessageToMessageEncoder;
import shade.io.netty.handler.codec.base64.Base64;
import shade.io.netty.handler.codec.base64.Base64Dialect;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.breakLines = breakLines;
        this.dialect = dialect;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.encode(msg, msg.readerIndex(), msg.readableBytes(), this.breakLines, this.dialect));
    }
}

