/*
 * Decompiled with CFR 0.152.
 */
package shade.io.opencensus.tags;

import javax.annotation.concurrent.Immutable;
import shade.io.opencensus.internal.StringUtils;
import shade.io.opencensus.internal.Utils;
import shade.io.opencensus.tags.AutoValue_TagKey;

@Immutable
public abstract class TagKey {
    public static final int MAX_LENGTH = 255;

    TagKey() {
    }

    public static TagKey create(String name) {
        Utils.checkArgument(TagKey.isValid(name), "Invalid TagKey name: %s", name);
        return new AutoValue_TagKey(name);
    }

    public abstract String getName();

    private static boolean isValid(String name) {
        return !name.isEmpty() && name.length() <= 255 && StringUtils.isPrintableString(name);
    }
}

