/*
 * Decompiled with CFR 0.152.
 */
package shade.io.opencensus.trace;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import shade.com.google.errorprone.annotations.MustBeClosed;
import shade.io.opencensus.common.Scope;
import shade.io.opencensus.internal.Utils;
import shade.io.opencensus.trace.BlankSpan;
import shade.io.opencensus.trace.CurrentSpanUtils;
import shade.io.opencensus.trace.Span;
import shade.io.opencensus.trace.SpanBuilder;
import shade.io.opencensus.trace.SpanContext;

public abstract class Tracer {
    private static final NoopTracer noopTracer = new NoopTracer();

    static Tracer getNoopTracer() {
        return noopTracer;
    }

    public final Span getCurrentSpan() {
        Span currentSpan = CurrentSpanUtils.getCurrentSpan();
        return currentSpan != null ? currentSpan : BlankSpan.INSTANCE;
    }

    @MustBeClosed
    public final Scope withSpan(Span span) {
        return CurrentSpanUtils.withSpan(Utils.checkNotNull(span, "span"), false);
    }

    public final Runnable withSpan(Span span, Runnable runnable) {
        return CurrentSpanUtils.withSpan(span, false, runnable);
    }

    public final <C> Callable<C> withSpan(Span span, Callable<C> callable) {
        return CurrentSpanUtils.withSpan(span, false, callable);
    }

    public final SpanBuilder spanBuilder(String spanName) {
        return this.spanBuilderWithExplicitParent(spanName, CurrentSpanUtils.getCurrentSpan());
    }

    public abstract SpanBuilder spanBuilderWithExplicitParent(String var1, @Nullable Span var2);

    public abstract SpanBuilder spanBuilderWithRemoteParent(String var1, @Nullable SpanContext var2);

    protected Tracer() {
    }

    private static final class NoopTracer
    extends Tracer {
        @Override
        public SpanBuilder spanBuilderWithExplicitParent(String spanName, @Nullable Span parent) {
            return SpanBuilder.NoopSpanBuilder.createWithParent(spanName, parent);
        }

        @Override
        public SpanBuilder spanBuilderWithRemoteParent(String spanName, @Nullable SpanContext remoteParentSpanContext) {
            return SpanBuilder.NoopSpanBuilder.createWithRemoteParent(spanName, remoteParentSpanContext);
        }

        private NoopTracer() {
        }
    }
}

