/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawBSDUnixDESCryptPassword;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public interface BSDUnixDESCryptPassword
extends OneWayPassword {
    public static final String ALGORITHM_BSD_CRYPT_DES = "bsd-crypt-des";
    public static final int BSD_CRYPT_DES_HASH_SIZE = 8;
    public static final int BSD_CRYPT_DES_SALT_SIZE = 3;
    public static final int DEFAULT_ITERATION_COUNT = 5001;

    public int getIterationCount();

    public int getSalt();

    public byte[] getHash();

    @Override
    default public IteratedSaltedPasswordAlgorithmSpec getParameterSpec() {
        int salt = this.getSalt();
        byte[] saltBytes = new byte[]{(byte)(salt >>> 24 & 0xFF), (byte)(salt >>> 16 & 0xFF), (byte)(salt >>> 8 & 0xFF), (byte)(salt & 0xFF)};
        return new IteratedSaltedPasswordAlgorithmSpec(this.getIterationCount(), saltBytes);
    }

    @Override
    default public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam((String)"parameterSpec", (Object)parameterSpec);
        if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
            IteratedSaltedPasswordAlgorithmSpec spec = (IteratedSaltedPasswordAlgorithmSpec)parameterSpec;
            return this.getIterationCount() <= spec.getIterationCount() && Arrays.equals(this.getParameterSpec().getSalt(), spec.getSalt());
        }
        if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
            return Arrays.equals(this.getParameterSpec().getSalt(), ((SaltedPasswordAlgorithmSpec)parameterSpec).getSalt());
        }
        if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
            return this.getIterationCount() <= ((IteratedPasswordAlgorithmSpec)parameterSpec).getIterationCount();
        }
        return false;
    }

    @Override
    public BSDUnixDESCryptPassword clone();

    public static BSDUnixDESCryptPassword createRaw(String algorithm, byte[] hash, int salt, int iterationCount) {
        Assert.checkNotNullParam((String)"hash", (Object)hash);
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        return new RawBSDUnixDESCryptPassword(algorithm, iterationCount, salt, (byte[])hash.clone());
    }
}

