/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.MaskedPassword;
import org.wildfly.security.password.interfaces.RawPassword;

final class RawMaskedPassword
extends RawPassword
implements MaskedPassword {
    private static final long serialVersionUID = -4344349209404192377L;
    private final char[] initialKeyMaterial;
    private final int iterationCount;
    private final byte[] salt;
    private final byte[] maskedPasswordBytes;

    RawMaskedPassword(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, byte[] maskedPasswordBytes) {
        super(algorithm);
        this.initialKeyMaterial = initialKeyMaterial;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.maskedPasswordBytes = maskedPasswordBytes;
    }

    @Override
    public char[] getInitialKeyMaterial() {
        return (char[])this.initialKeyMaterial.clone();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public byte[] getMaskedPasswordBytes() {
        return (byte[])this.maskedPasswordBytes.clone();
    }

    @Override
    public RawMaskedPassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)Arrays.hashCode(this.initialKeyMaterial), (int)Arrays.hashCode(this.salt)), (int)Arrays.hashCode(this.maskedPasswordBytes)), (int)this.iterationCount), (int)this.getAlgorithm().hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawMaskedPassword)) {
            return false;
        }
        RawMaskedPassword other = (RawMaskedPassword)obj;
        return this.iterationCount == other.iterationCount && Arrays.equals(this.initialKeyMaterial, other.initialKeyMaterial) && Arrays.equals(this.salt, other.salt) && Arrays.equals(this.maskedPasswordBytes, other.maskedPasswordBytes) && this.getAlgorithm().equals(other.getAlgorithm());
    }
}

