/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gs2;

import java.util.ArrayList;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.wildfly.security.sasl.WildFlySasl;
import org.wildfly.security.sasl.gs2.Gs2;
import org.wildfly.security.util.ByteStringBuilder;

class Gs2Util {
    public static final int TOKEN_HEADER_TAG = 96;

    Gs2Util() {
    }

    public static String[] getSupportedSaslNamesForMechanisms(Oid[] mechanismOids) throws GSSException {
        if (mechanismOids == null) {
            return WildFlySasl.NO_NAMES;
        }
        ArrayList<String> saslNames = new ArrayList<String>();
        ArrayList<String> nonPlusSaslNames = new ArrayList<String>();
        for (int i = 0; i < mechanismOids.length; ++i) {
            String name = Gs2.getSaslNameForMechanism(mechanismOids[i]);
            if (name.equals("SPNEGO")) continue;
            nonPlusSaslNames.add(name);
            saslNames.add(name + "-PLUS");
        }
        saslNames.addAll(nonPlusSaslNames);
        return saslNames.toArray(new String[saslNames.size()]);
    }

    public static boolean isIncluded(String name, String[] mechanisms) {
        if (name == null || mechanisms == null) {
            return false;
        }
        for (String mechanism : mechanisms) {
            if (!name.equals(mechanism)) continue;
            return true;
        }
        return false;
    }

    public static String[] getPlusMechanisms(String[] mechanisms) {
        ArrayList<String> plusMechanisms = new ArrayList<String>();
        for (String mechanism : mechanisms) {
            if (!mechanism.endsWith("-PLUS")) continue;
            plusMechanisms.add(mechanism);
        }
        return plusMechanisms.toArray(new String[plusMechanisms.size()]);
    }

    public static ChannelBinding createChannelBinding(byte[] header, boolean gs2CbFlagPUsed, byte[] bindingData) {
        ByteStringBuilder appData = new ByteStringBuilder(header);
        if (gs2CbFlagPUsed) {
            appData.append(bindingData);
        }
        return new ChannelBinding(appData.toArray());
    }
}

