/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;

public class JsonUtil {
    public static Attributes toAttributes(JsonObject claims) {
        return claims.entrySet().stream().reduce(new MapAttributes(), (mapAttributes, entry) -> {
            String claimName = (String)entry.getKey();
            JsonValue claimValue = (JsonValue)entry.getValue();
            if (JsonValue.ValueType.ARRAY.equals((Object)claimValue.getValueType())) {
                JsonArray jsonArray = claims.getJsonArray(claimName);
                jsonArray.forEach(arrayValue -> mapAttributes.addLast(claimName, JsonUtil.asString(arrayValue)));
            } else {
                mapAttributes.addLast(claimName, JsonUtil.asString(claimValue));
            }
            return mapAttributes;
        }, (mapAttributes, mapAttributes2) -> mapAttributes);
    }

    private static String asString(JsonValue value) {
        if (JsonValue.ValueType.STRING.equals((Object)value.getValueType())) {
            return ((JsonString)value).getString();
        }
        return value.toString();
    }
}

