/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.util.Cache;
import org.zkoss.util.CacheMap;

public class MultiCache<K, V>
implements Cache<K, V>,
Serializable,
Cloneable {
    private final CacheMap<K, V>[] _caches;
    private int _maxsize;
    private int _lifetime;

    public MultiCache() {
        this(17);
    }

    public MultiCache(int nCache, int maxSize, int lifetime) {
        if (nCache <= 0) {
            throw new IllegalArgumentException();
        }
        this._caches = new CacheMap[nCache];
        this._maxsize = maxSize;
        this._lifetime = lifetime;
    }

    public MultiCache(int nCache) {
        this(nCache, 51, 1800000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        CacheMap<K, V> cache;
        CacheMap<K, V> cacheMap = cache = this.getCache(key);
        synchronized (cacheMap) {
            return cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        CacheMap<K, V> cache;
        CacheMap<K, V> cacheMap = cache = this.getCache(key);
        synchronized (cacheMap) {
            return cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        CacheMap<K, V> cache;
        CacheMap<K, V> cacheMap = cache = this.getCache(key);
        synchronized (cacheMap) {
            return cache.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        CacheMap<K, V> cache;
        CacheMap<K, V> cacheMap = cache = this.getCache(key);
        synchronized (cacheMap) {
            return cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MultiCache multiCache = this;
        synchronized (multiCache) {
            for (int j = 0; j < this._caches.length; ++j) {
                this._caches[j] = null;
            }
        }
    }

    protected int getInnerCacheHashCode(Object key) {
        return Objects.hashCode(key) ^ Objects.hashCode(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheMap<K, V> getCache(Object key) {
        int j = this.getInnerCacheHashCode(key);
        j = (j >= 0 ? j : -j) % this._caches.length;
        CacheMap<K, V> cache = this._caches[j];
        if (cache == null) {
            MultiCache multiCache = this;
            synchronized (multiCache) {
                cache = this._caches[j];
                if (cache == null) {
                    cache = new CacheMap(4);
                    cache.setMaxSize(this._maxsize);
                    cache.setLifetime(this._lifetime);
                    this._caches[j] = cache;
                }
            }
        }
        return cache;
    }

    @Override
    public int getLifetime() {
        return this._lifetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLifetime(int lifetime) {
        this._lifetime = lifetime;
        for (int j = 0; j < this._caches.length; ++j) {
            if (this._caches[j] == null) continue;
            CacheMap<K, V> cacheMap = this._caches[j];
            synchronized (cacheMap) {
                this._caches[j].setLifetime(lifetime);
                continue;
            }
        }
    }

    @Override
    public int getMaxSize() {
        return this._maxsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxSize(int maxsize) {
        this._maxsize = maxsize;
        for (int j = 0; j < this._caches.length; ++j) {
            if (this._caches[j] == null) continue;
            CacheMap<K, V> cacheMap = this._caches[j];
            synchronized (cacheMap) {
                this._caches[j].setMaxSize(maxsize);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        MultiCache<K, V> clone = new MultiCache<K, V>(this._caches.length, this._maxsize, this._lifetime);
        for (int j = 0; j < this._caches.length; ++j) {
            if (this._caches[j] == null) continue;
            CacheMap<K, V> cacheMap = this._caches[j];
            synchronized (cacheMap) {
                clone._caches[j] = (CacheMap)this._caches[j].clone();
                continue;
            }
        }
        return clone;
    }
}

