/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import org.zkoss.lang.PotentialDeadLockException;
import org.zkoss.lang.SystemException;

public class WaitLock {
    private final Thread _locker = Thread.currentThread();
    private boolean _unlocked;

    public synchronized boolean waitUntilUnlock(int timeout) {
        if (!this._unlocked) {
            if (Thread.currentThread().equals(this._locker)) {
                throw new PotentialDeadLockException("Wait for itself?");
            }
            try {
                this.wait(timeout);
            }
            catch (InterruptedException ex) {
                throw SystemException.Aide.wrap(ex);
            }
        }
        return this._unlocked;
    }

    public synchronized void unlock() {
        this._unlocked = true;
        this.notifyAll();
    }
}

