/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel;

import java.beans.FeatureDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.zel.BeanNameResolver;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.PropertyNotWritableException;
import org.zkoss.zel.Util;

public class BeanNameELResolver
extends ELResolver {
    private final BeanNameResolver beanNameResolver;

    public BeanNameELResolver(BeanNameResolver beanNameResolver) {
        this.beanNameResolver = beanNameResolver;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null || !(property instanceof String)) {
            return null;
        }
        String beanName = (String)property;
        if (this.isNameResolved(context, beanName)) {
            try {
                Object result = this.getBean(context, (String)property);
                context.setPropertyResolved(base, property);
                return result;
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
                throw new ELException(t);
            }
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        boolean isReadOnly;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null || !(property instanceof String)) {
            return;
        }
        String beanName = (String)property;
        boolean isResolved = context.isPropertyResolved();
        try {
            isReadOnly = this.isReadOnly(context, base, property);
        }
        catch (Throwable t) {
            Util.handleThrowable(t);
            throw new ELException(t);
        }
        finally {
            context.setPropertyResolved(isResolved);
        }
        if (isReadOnly) {
            throw new PropertyNotWritableException(Util.message(context, "beanNameELResolver.beanReadOnly", beanName));
        }
        if (this.isNameResolved(context, beanName) || this.beanNameResolver.canCreateBean(beanName)) {
            try {
                this.setBeanValue(context, beanName, value);
                context.setPropertyResolved(base, property);
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
                throw new ELException(t);
            }
        }
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null || !(property instanceof String)) {
            return null;
        }
        String beanName = (String)property;
        try {
            if (this.isNameResolved(context, beanName)) {
                Object bean = this.getBean(context, beanName);
                if (bean == null) {
                    return null;
                }
                Class<?> result = bean.getClass();
                context.setPropertyResolved(base, property);
                return result;
            }
        }
        catch (Throwable t) {
            Util.handleThrowable(t);
            throw new ELException(t);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null || !(property instanceof String)) {
            return false;
        }
        String beanName = (String)property;
        if (this.isNameResolved(context, beanName)) {
            boolean result;
            try {
                result = this.beanNameResolver.isReadOnly(beanName);
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
                throw new ELException(t);
            }
            context.setPropertyResolved(base, property);
            return result;
        }
        return false;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }

    private boolean isNameResolved(ELContext context, String beanName) {
        Map cache = (Map)context.getContext(this.beanNameResolver.getClass());
        return cache != null && cache.containsKey(beanName);
    }

    private Object getBean(ELContext context, String beanName) {
        Map cache = (Map)context.getContext(this.beanNameResolver.getClass());
        return cache != null ? cache.get(beanName) : null;
    }

    private void setBeanValue(ELContext context, String beanName, Object value) throws PropertyNotWritableException {
        Class<?> key = this.beanNameResolver.getClass();
        HashMap<String, Object> cache = (HashMap<String, Object>)context.getContext(key);
        if (cache == null) {
            cache = new HashMap<String, Object>();
            context.putContext(key, cache);
        }
        cache.put(beanName, value);
    }
}

