/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Phase;
import org.zkoss.bind.Property;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.zk.ui.Component;

public abstract class AbstractBindingHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Binder _binder;

    public void setBinder(Binder binder) {
        this._binder = binder;
    }

    protected void doPrePhase(Phase phase, BindContext ctx) {
        ((BinderImpl)this._binder).doPrePhase(phase, ctx);
    }

    protected void doPostPhase(Phase phase, BindContext ctx) {
        ((BinderImpl)this._binder).doPostPhase(phase, ctx);
    }

    protected static Set<Property> getNotifys(BindContext ctx) {
        return (Set)ctx.getAttribute("$NOTIFYS$");
    }

    protected void clearValidationMessages(Binder binder, Component component, String attr) {
        ValidationMessages vmsgs = ((BinderCtrl)((Object)binder)).getValidationMessages();
        if (vmsgs != null) {
            vmsgs.clearMessages(component, attr);
        }
    }

    protected <K, V> void addBinding(Map<K, List<V>> bindingsMap, K bkey, V binding) {
        List<V> bindings = bindingsMap.get(bkey);
        List<V> bindings0 = AllocUtil.inst.addList(bindings, binding);
        if (bindings0 != bindings) {
            bindingsMap.put(bkey, bindings0);
        }
    }

    protected String getSaveBindingDebugInfo(String operation, Object ... args) {
        return MessageFormat.format(operation + ":binding.save() comp=[{0}],binding=[{1}],command=[{2}],evt=[{3}],notifys=[{4}]", args);
    }

    protected String getLoadBindingDebugInfo(String operation, Object ... args) {
        return MessageFormat.format(operation + ":binding.load() comp=[{0}],binding=[{1}],context=[{2}],command=[{3}]", args);
    }
}

