/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zsoup.examples;

import java.io.IOException;
import org.zkoss.zsoup.Zsoup;
import org.zkoss.zsoup.helper.StringUtil;
import org.zkoss.zsoup.helper.Validate;
import org.zkoss.zsoup.nodes.Document;
import org.zkoss.zsoup.nodes.Element;
import org.zkoss.zsoup.nodes.Node;
import org.zkoss.zsoup.nodes.TextNode;
import org.zkoss.zsoup.select.NodeTraversor;
import org.zkoss.zsoup.select.NodeVisitor;

public class HtmlToPlainText {
    public static void main(String ... args) throws IOException {
        Validate.isTrue(args.length == 1, "usage: supply url to fetch");
        String url = args[0];
        Document doc = Zsoup.connect(url).get();
        HtmlToPlainText formatter = new HtmlToPlainText();
        String plainText = formatter.getPlainText(doc);
        System.out.println(plainText);
    }

    public String getPlainText(Element element) {
        FormattingVisitor formatter = new FormattingVisitor();
        NodeTraversor traversor = new NodeTraversor(formatter);
        traversor.traverse(element);
        return formatter.toString();
    }

    private class FormattingVisitor
    implements NodeVisitor {
        private static final int maxWidth = 80;
        private int width = 0;
        private StringBuilder accum = new StringBuilder();

        private FormattingVisitor() {
        }

        public void head(Node node, int depth) {
            String name = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (name.equals("li")) {
                this.append("\n * ");
            }
        }

        public void tail(Node node, int depth) {
            String name = node.nodeName();
            if (name.equals("br")) {
                this.append("\n");
            } else if (StringUtil.in(name, "p", "h1", "h2", "h3", "h4", "h5")) {
                this.append("\n\n");
            } else if (name.equals("a")) {
                this.append(String.format(" <%s>", node.absUrl("href")));
            }
        }

        private void append(String text) {
            if (text.startsWith("\n")) {
                this.width = 0;
            }
            if (text.equals(" ") && (this.accum.length() == 0 || StringUtil.in(this.accum.substring(this.accum.length() - 1), " ", "\n"))) {
                return;
            }
            if (text.length() + this.width > 80) {
                String[] words = text.split("\\s+");
                for (int i = 0; i < words.length; ++i) {
                    boolean last;
                    String word = words[i];
                    boolean bl = last = i == words.length - 1;
                    if (!last) {
                        word = word + " ";
                    }
                    if (word.length() + this.width > 80) {
                        this.accum.append("\n").append(word);
                        this.width = word.length();
                        continue;
                    }
                    this.accum.append(word);
                    this.width += word.length();
                }
            } else {
                this.accum.append(text);
                this.width += text.length();
            }
        }

        public String toString() {
            return this.accum.toString();
        }
    }
}

