/*
 * Decompiled with CFR 0.152.
 */
package com.github.structlog4j;

import com.github.structlog4j.IFormatter;
import com.github.structlog4j.ILogger;
import com.github.structlog4j.IToLog;
import com.github.structlog4j.StructLog4J;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class SLogger
implements ILogger {
    private static final String KEY_ERROR_MESSAGE = "errorMessage";
    private static final String SPACE = " ";
    private final Logger slfjLogger;

    SLogger(String name) {
        this.slfjLogger = LoggerFactory.getLogger((String)name);
    }

    SLogger(Class<?> source) {
        this.slfjLogger = LoggerFactory.getLogger(source);
    }

    @Override
    public void error(String message, Object ... params) {
        if (this.slfjLogger.isErrorEnabled()) {
            this.log(Level.ERROR, message, params);
        }
    }

    @Override
    public void warn(String message, Object ... params) {
        if (this.slfjLogger.isWarnEnabled()) {
            this.log(Level.WARN, message, params);
        }
    }

    @Override
    public void info(String message, Object ... params) {
        if (this.slfjLogger.isInfoEnabled()) {
            this.log(Level.INFO, message, params);
        }
    }

    @Override
    public void debug(String message, Object ... params) {
        if (this.slfjLogger.isDebugEnabled()) {
            this.log(Level.DEBUG, message, params);
        }
    }

    @Override
    public void trace(String message, Object ... params) {
        if (this.slfjLogger.isTraceEnabled()) {
            this.log(Level.TRACE, message, params);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.slfjLogger.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.slfjLogger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.slfjLogger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.slfjLogger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.slfjLogger.isTraceEnabled();
    }

    private void log(Level level, String message, Object ... params) {
        try {
            if (message == null) {
                message = "";
            }
            Throwable e = null;
            IFormatter formatter = StructLog4J.getFormatter();
            Object bld = formatter.start(this.slfjLogger);
            formatter.addMessage(this.slfjLogger, bld, message);
            boolean processKeyValues = true;
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (param instanceof IToLog) {
                    this.handleIToLog(formatter, bld, (IToLog)param);
                    continue;
                }
                if (param instanceof Throwable) {
                    e = (Throwable)param;
                    formatter.addKeyValue(this.slfjLogger, bld, KEY_ERROR_MESSAGE, this.getCauseErrorMessage(e));
                    continue;
                }
                if (!processKeyValues || ++i >= params.length || this.handleKeyValue(formatter, bld, param, params[i], null)) continue;
                processKeyValues = false;
            }
            Optional<IToLog> mandatory = StructLog4J.getMandatoryContextSupplier();
            mandatory.ifPresent(iToLog -> this.handleIToLog(formatter, bld, (IToLog)iToLog));
            String logEntry = formatter.end(this.slfjLogger, bld);
            this.log(level, logEntry, e);
        }
        catch (Exception ex) {
            this.slfjLogger.error("UNEXPECTED LOGGER ERROR: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void handleIToLog(IFormatter encoder, Object bld, IToLog loggable) {
        Object[] logParams = loggable.toLog();
        if (logParams == null) {
            this.slfjLogger.error("Null returned from {}.toLog()", loggable.getClass());
            return;
        }
        if (logParams.length % 2 != 0) {
            this.slfjLogger.error("Odd number of parameters ({}) returned from {}.toLog()", (Object)logParams.length, loggable.getClass());
            return;
        }
        for (int i = 0; i < logParams.length; i += 2) {
            this.handleKeyValue(encoder, bld, logParams[i], logParams[i + 1], loggable);
        }
    }

    private boolean handleKeyValue(IFormatter formatter, Object bld, Object keyObject, Object value, IToLog source) {
        String key;
        if (keyObject != null && keyObject instanceof String) {
            key = (String)keyObject;
            if (key.indexOf(SPACE) >= 0) {
                if (source == null) {
                    this.slfjLogger.error("Key with spaces was passed in: {}", (Object)key);
                } else {
                    this.slfjLogger.error("Key with spaces was passed in from {}.toLog(): {}", source.getClass(), (Object)key);
                }
                return false;
            }
        } else {
            if (source == null) {
                this.slfjLogger.error("Non-String or null key was passed in: {} ({})", keyObject, keyObject != null ? keyObject.getClass() : "null");
            } else {
                this.slfjLogger.error("Non-String or null key was passed in from {}.toLog(): {} ({})", new Object[]{source.getClass(), keyObject, keyObject != null ? keyObject.getClass() : "null"});
            }
            return false;
        }
        formatter.addKeyValue(this.slfjLogger, bld, key, value);
        return true;
    }

    private void log(Level level, String structuredMessage, Throwable err) {
        switch (level) {
            case ERROR: {
                if (err == null) {
                    this.slfjLogger.error(structuredMessage);
                    break;
                }
                this.slfjLogger.error(structuredMessage, err);
                break;
            }
            case WARN: {
                if (err == null) {
                    this.slfjLogger.warn(structuredMessage);
                    break;
                }
                this.slfjLogger.warn(structuredMessage, err);
                break;
            }
            case INFO: {
                if (err == null) {
                    this.slfjLogger.info(structuredMessage);
                    break;
                }
                this.slfjLogger.info(structuredMessage, err);
                break;
            }
            case DEBUG: {
                if (err == null) {
                    this.slfjLogger.debug(structuredMessage);
                    break;
                }
                this.slfjLogger.debug(structuredMessage, err);
                break;
            }
            case TRACE: {
                if (err == null) {
                    this.slfjLogger.trace(structuredMessage);
                    break;
                }
                this.slfjLogger.trace(structuredMessage, err);
                break;
            }
        }
    }

    private String getCauseErrorMessage(Throwable t) {
        if (t.getCause() == null) {
            return t.getMessage();
        }
        return this.getCauseErrorMessage(t.getCause());
    }

    @ConstructorProperties(value={"slfjLogger"})
    public SLogger(Logger slfjLogger) {
        this.slfjLogger = slfjLogger;
    }

    public Logger getSlfjLogger() {
        return this.slfjLogger;
    }
}

