/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.official.processors.impl.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import shade.powerjob.com.google.common.collect.Maps;
import tech.powerjob.official.processors.impl.sql.AbstractSqlProcessor;
import tech.powerjob.worker.core.processor.TaskContext;

public class SpringDatasourceSqlProcessor
extends AbstractSqlProcessor {
    private static final Logger log = LoggerFactory.getLogger(SpringDatasourceSqlProcessor.class);
    private static final String DEFAULT_DATASOURCE_NAME = "default";
    private final Map<String, DataSource> dataSourceMap = Maps.newConcurrentMap();

    public SpringDatasourceSqlProcessor(DataSource defaultDataSource) {
        this.registerDataSource(DEFAULT_DATASOURCE_NAME, defaultDataSource);
    }

    @Override
    Connection getConnection(AbstractSqlProcessor.SqlParams sqlParams, TaskContext taskContext) throws SQLException {
        return this.dataSourceMap.get(sqlParams.getDataSourceName()).getConnection();
    }

    @Override
    protected void validateParams(AbstractSqlProcessor.SqlParams sqlParams) {
        if (StringUtils.isEmpty((Object)sqlParams.getDataSourceName())) {
            sqlParams.setDataSourceName(DEFAULT_DATASOURCE_NAME);
        }
        this.dataSourceMap.computeIfAbsent(sqlParams.getDataSourceName(), dataSourceName -> {
            throw new IllegalArgumentException("can't find data source with name " + dataSourceName);
        });
    }

    public void registerDataSource(String dataSourceName, DataSource dataSource) {
        Assert.notNull((Object)dataSourceName, (String)"DataSource name must not be null");
        Assert.notNull((Object)dataSource, (String)"DataSource must not be null");
        this.dataSourceMap.put(dataSourceName, dataSource);
        log.info("register data source({})' successfully.", (Object)dataSourceName);
    }

    public void removeDataSource(String dataSourceName) {
        DataSource remove = this.dataSourceMap.remove(dataSourceName);
        if (remove != null) {
            log.warn("remove data source({})' successfully.", (Object)dataSourceName);
        }
    }
}

