/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.common.thread;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewThreadRunRejectedExecutionHandler
implements RejectedExecutionHandler {
    private static final Logger log = LoggerFactory.getLogger(NewThreadRunRejectedExecutionHandler.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final String source;

    public NewThreadRunRejectedExecutionHandler(String source) {
        this.source = source;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor p) {
        log.error("[{}] ThreadPool[{}] overload, the task[{}] will run by a new thread!, Maybe you need to adjust the ThreadPool config!", new Object[]{this.source, p, r});
        if (!p.isShutdown()) {
            String threadName = this.source + "-T-" + COUNTER.getAndIncrement();
            log.info("[{}] create new thread[{}] to run job", (Object)this.source, (Object)threadName);
            new Thread(r, threadName).start();
        }
    }
}

