/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.util.DigestUtils;
import tech.powerjob.common.utils.CommonUtils;

public class OmsFileUtils {
    private static final String USER_HOME = System.getProperty("user.home", "oms");
    private static final String COMMON_PATH = USER_HOME + "/powerjob/server/";

    public static String genLogDirPath() {
        return COMMON_PATH + "online_log/";
    }

    public static String genContainerJarPath() {
        return COMMON_PATH + "container/";
    }

    public static String genTemporaryPath() {
        return COMMON_PATH + "temporary/";
    }

    public static String genTemporaryWorkPath() {
        return OmsFileUtils.genTemporaryPath() + CommonUtils.genUUID() + "/";
    }

    public static String genH2BasePath() {
        return COMMON_PATH + "h2/";
    }

    public static String genH2WorkPath() {
        return OmsFileUtils.genH2BasePath() + CommonUtils.genUUID() + "/";
    }

    public static void string2File(String content, File file) {
        try (FileWriter fw = new FileWriter(file);){
            fw.write(content);
        }
        catch (IOException ie) {
            ExceptionUtils.rethrow((Throwable)ie);
        }
    }

    public static void file2HttpResponse(File file, HttpServletResponse response) throws IOException {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(file.getName(), "UTF-8"));
        byte[] buffer = new byte[4096];
        try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
             BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            while (bis.read(buffer) != -1) {
                bos.write(buffer);
            }
        }
    }

    public static String md5(File f) throws IOException {
        String md5;
        try (FileInputStream fis = new FileInputStream(f);){
            md5 = DigestUtils.md5DigestAsHex((InputStream)fis);
        }
        return md5;
    }
}

