/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.uid;

public class SnowFlakeIdGenerator {
    private static final long START_STAMP = 1555776000000L;
    private static final long SEQUENCE_BIT = 6L;
    private static final long MACHINE_BIT = 14L;
    private static final long DATA_CENTER_BIT = 2L;
    private static final long MAX_DATA_CENTER_NUM = 3L;
    private static final long MAX_MACHINE_NUM = 16383L;
    private static final long MAX_SEQUENCE = 63L;
    private static final long MACHINE_LEFT = 6L;
    private static final long DATA_CENTER_LEFT = 20L;
    private static final long TIMESTAMP_LEFT = 22L;
    private final long dataCenterId;
    private final long machineId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowFlakeIdGenerator(long dataCenterId, long machineId) {
        if (dataCenterId > 3L || dataCenterId < 0L) {
            throw new IllegalArgumentException("dataCenterId can't be greater than MAX_DATA_CENTER_NUM or less than 0");
        }
        if (machineId > 16383L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.dataCenterId = dataCenterId;
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long currStamp = this.getNewStamp();
        if (currStamp < this.lastTimestamp) {
            return this.futureId();
        }
        if (currStamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0x3FL;
            if (this.sequence == 0L) {
                currStamp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currStamp;
        return currStamp - 1555776000000L << 22 | this.dataCenterId << 20 | this.machineId << 6 | this.sequence;
    }

    private long futureId() {
        this.sequence = this.sequence + 1L & 0x3FL;
        if (this.sequence == 0L) {
            ++this.lastTimestamp;
        }
        return this.lastTimestamp - 1555776000000L << 22 | this.dataCenterId << 20 | this.machineId << 6 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewStamp();
        while (mill <= this.lastTimestamp) {
            mill = this.getNewStamp();
        }
        return mill;
    }

    private long getNewStamp() {
        return System.currentTimeMillis();
    }
}

