/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.instance;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import tech.powerjob.common.PowerQuery;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.InstanceDetail;
import tech.powerjob.common.request.ServerQueryInstanceStatusReq;
import tech.powerjob.common.request.ServerStopInstanceReq;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.common.response.InstanceInfoDTO;
import tech.powerjob.remote.framework.base.URL;
import tech.powerjob.server.common.constants.InstanceType;
import tech.powerjob.server.common.module.WorkerInfo;
import tech.powerjob.server.common.timewheel.TimerFuture;
import tech.powerjob.server.common.timewheel.holder.InstanceTimeWheelService;
import tech.powerjob.server.core.DispatchService;
import tech.powerjob.server.core.instance.InstanceManager;
import tech.powerjob.server.core.uid.IdGenerateService;
import tech.powerjob.server.persistence.QueryConvertUtils;
import tech.powerjob.server.persistence.remote.model.InstanceInfoDO;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.repository.InstanceInfoRepository;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;
import tech.powerjob.server.remote.server.redirector.DesignateServer;
import tech.powerjob.server.remote.transporter.TransportService;
import tech.powerjob.server.remote.transporter.impl.ServerURLFactory;
import tech.powerjob.server.remote.worker.WorkerClusterQueryService;

@Service
public class InstanceService {
    private static final Logger log = LoggerFactory.getLogger(InstanceService.class);
    private final TransportService transportService;
    private final DispatchService dispatchService;
    private final IdGenerateService idGenerateService;
    private final InstanceManager instanceManager;
    private final JobInfoRepository jobInfoRepository;
    private final InstanceInfoRepository instanceInfoRepository;
    private final WorkerClusterQueryService workerClusterQueryService;

    public InstanceInfoDO create(Long jobId, Long appId, String jobParams, String instanceParams, Long wfInstanceId, Long expectTriggerTime) {
        Long instanceId = this.idGenerateService.allocate();
        Date now = new Date();
        InstanceInfoDO newInstanceInfo = new InstanceInfoDO();
        newInstanceInfo.setJobId(jobId);
        newInstanceInfo.setAppId(appId);
        newInstanceInfo.setInstanceId(instanceId);
        newInstanceInfo.setJobParams(jobParams);
        newInstanceInfo.setInstanceParams(instanceParams);
        newInstanceInfo.setType(Integer.valueOf(wfInstanceId == null ? InstanceType.NORMAL.getV() : InstanceType.WORKFLOW.getV()));
        newInstanceInfo.setWfInstanceId(wfInstanceId);
        newInstanceInfo.setStatus(Integer.valueOf(InstanceStatus.WAITING_DISPATCH.getV()));
        newInstanceInfo.setRunningTimes(Long.valueOf(0L));
        newInstanceInfo.setExpectedTriggerTime(expectTriggerTime);
        newInstanceInfo.setLastReportTime(Long.valueOf(-1L));
        newInstanceInfo.setGmtCreate(now);
        newInstanceInfo.setGmtModified(now);
        this.instanceInfoRepository.save((Object)newInstanceInfo);
        return newInstanceInfo;
    }

    @DesignateServer
    public void stopInstance(Long appId, Long instanceId) {
        log.info("[Instance-{}] try to stop the instance instance in appId: {}", (Object)instanceId, (Object)appId);
        try {
            InstanceInfoDO instanceInfo = this.fetchInstanceInfo(instanceId);
            if (!InstanceStatus.GENERALIZED_RUNNING_STATUS.contains(instanceInfo.getStatus())) {
                throw new IllegalArgumentException("can't stop finished instance!");
            }
            instanceInfo.setStatus(Integer.valueOf(InstanceStatus.STOPPED.getV()));
            instanceInfo.setGmtModified(new Date());
            instanceInfo.setFinishedTime(Long.valueOf(System.currentTimeMillis()));
            instanceInfo.setResult("stopped by user");
            this.instanceInfoRepository.saveAndFlush((Object)instanceInfo);
            this.instanceManager.processFinishedInstance(instanceId, instanceInfo.getWfInstanceId(), InstanceStatus.STOPPED, "stopped by user");
            Optional workerInfoOpt = this.workerClusterQueryService.getWorkerInfoByAddress(instanceInfo.getAppId(), instanceInfo.getTaskTrackerAddress());
            if (workerInfoOpt.isPresent()) {
                ServerStopInstanceReq req = new ServerStopInstanceReq(instanceId);
                WorkerInfo workerInfo = (WorkerInfo)workerInfoOpt.get();
                this.transportService.tell(workerInfo.getProtocol(), ServerURLFactory.stopInstance2Worker((String)workerInfo.getAddress()), (PowerSerializable)req);
                log.info("[Instance-{}] update instanceInfo and send 'stopInstance' request succeed.", (Object)instanceId);
            } else {
                log.warn("[Instance-{}] update instanceInfo successfully but can't find TaskTracker to stop instance", (Object)instanceId);
            }
        }
        catch (IllegalArgumentException ie) {
            throw ie;
        }
        catch (Exception e) {
            log.error("[Instance-{}] stopInstance failed.", (Object)instanceId, (Object)e);
            throw e;
        }
    }

    @DesignateServer
    public void retryInstance(Long appId, Long instanceId) {
        log.info("[Instance-{}] retry instance in appId: {}", (Object)instanceId, (Object)appId);
        InstanceInfoDO instanceInfo = this.fetchInstanceInfo(instanceId);
        if (!InstanceStatus.FINISHED_STATUS.contains(instanceInfo.getStatus())) {
            throw new PowerJobException("Only stopped instance can be retry!");
        }
        if (instanceInfo.getWfInstanceId() != null) {
            throw new PowerJobException("Workflow's instance do not support retry!");
        }
        instanceInfo.setStatus(Integer.valueOf(InstanceStatus.WAITING_DISPATCH.getV()));
        instanceInfo.setExpectedTriggerTime(Long.valueOf(System.currentTimeMillis()));
        instanceInfo.setFinishedTime(null);
        instanceInfo.setActualTriggerTime(null);
        instanceInfo.setTaskTrackerAddress(null);
        instanceInfo.setResult(null);
        this.instanceInfoRepository.saveAndFlush((Object)instanceInfo);
        Long jobId = instanceInfo.getJobId();
        JobInfoDO jobInfo = (JobInfoDO)this.jobInfoRepository.findById((Object)jobId).orElseThrow(() -> new PowerJobException("can't find job info by jobId: " + jobId));
        this.dispatchService.dispatch(jobInfo, instanceId, Optional.of(instanceInfo), Optional.empty());
    }

    @DesignateServer
    public void cancelInstance(Long appId, Long instanceId) {
        log.info("[Instance-{}] try to cancel the instance with appId {}.", (Object)instanceId, (Object)appId);
        try {
            boolean success;
            InstanceInfoDO instanceInfo = this.fetchInstanceInfo(instanceId);
            TimerFuture timerFuture = InstanceTimeWheelService.fetchTimerFuture((Long)instanceId);
            if (timerFuture != null) {
                success = timerFuture.cancel();
            } else {
                boolean bl = success = InstanceStatus.WAITING_DISPATCH.getV() == instanceInfo.getStatus().intValue();
            }
            if (!success) {
                log.warn("[Instance-{}] cancel the instance failed.", (Object)instanceId);
                throw new PowerJobException("instance already up and running");
            }
            instanceInfo.setStatus(Integer.valueOf(InstanceStatus.CANCELED.getV()));
            instanceInfo.setResult("canceled by user");
            this.instanceInfoRepository.saveAndFlush((Object)instanceInfo);
            log.info("[Instance-{}] cancel the instance successfully.", (Object)instanceId);
        }
        catch (Exception e) {
            log.error("[Instance-{}] cancelInstance failed.", (Object)instanceId, (Object)e);
            throw e;
        }
    }

    public List<InstanceInfoDTO> queryInstanceInfo(PowerQuery powerQuery) {
        return this.instanceInfoRepository.findAll(QueryConvertUtils.toSpecification((PowerQuery)powerQuery)).stream().map(InstanceService::directConvert).collect(Collectors.toList());
    }

    public InstanceInfoDTO getInstanceInfo(Long instanceId) {
        return InstanceService.directConvert(this.fetchInstanceInfo(instanceId));
    }

    public InstanceStatus getInstanceStatus(Long instanceId) {
        InstanceInfoDO instanceInfoDO = this.fetchInstanceInfo(instanceId);
        return InstanceStatus.of((int)instanceInfoDO.getStatus());
    }

    @DesignateServer
    public InstanceDetail getInstanceDetail(Long appId, Long instanceId, String customQuery) {
        InstanceInfoDO instanceInfoDO = this.fetchInstanceInfo(instanceId);
        InstanceStatus instanceStatus = InstanceStatus.of((int)instanceInfoDO.getStatus());
        InstanceDetail detail = new InstanceDetail();
        detail.setStatus(Integer.valueOf(instanceStatus.getV()));
        if (instanceStatus != InstanceStatus.RUNNING) {
            BeanUtils.copyProperties((Object)instanceInfoDO, (Object)detail);
            return detail;
        }
        Optional workerInfoOpt = this.workerClusterQueryService.getWorkerInfoByAddress(instanceInfoDO.getAppId(), instanceInfoDO.getTaskTrackerAddress());
        if (workerInfoOpt.isPresent()) {
            WorkerInfo workerInfo = (WorkerInfo)workerInfoOpt.get();
            ServerQueryInstanceStatusReq req = new ServerQueryInstanceStatusReq(instanceId, customQuery);
            try {
                URL url = ServerURLFactory.queryInstance2Worker((String)workerInfo.getAddress());
                AskResponse askResponse = (AskResponse)this.transportService.ask(workerInfo.getProtocol(), url, (PowerSerializable)req, AskResponse.class).toCompletableFuture().get(5000L, TimeUnit.MILLISECONDS);
                if (askResponse.isSuccess()) {
                    InstanceDetail instanceDetail = (InstanceDetail)askResponse.getData(InstanceDetail.class);
                    instanceDetail.setRunningTimes(instanceInfoDO.getRunningTimes());
                    instanceDetail.setInstanceParams(instanceInfoDO.getInstanceParams());
                    return instanceDetail;
                }
                log.warn("[Instance-{}] ask InstanceStatus from TaskTracker failed, the message is {}.", (Object)instanceId, (Object)askResponse.getMessage());
            }
            catch (Exception e) {
                log.warn("[Instance-{}] ask InstanceStatus from TaskTracker failed, exception is {}", (Object)instanceId, (Object)e.toString());
            }
        }
        BeanUtils.copyProperties((Object)instanceInfoDO, (Object)detail);
        return detail;
    }

    private InstanceInfoDO fetchInstanceInfo(Long instanceId) {
        InstanceInfoDO instanceInfoDO = this.instanceInfoRepository.findByInstanceId(instanceId.longValue());
        if (instanceInfoDO == null) {
            log.warn("[Instance-{}] can't find InstanceInfo by instanceId", (Object)instanceId);
            throw new IllegalArgumentException("invalid instanceId: " + instanceId);
        }
        return instanceInfoDO;
    }

    private static InstanceInfoDTO directConvert(InstanceInfoDO instanceInfoDO) {
        InstanceInfoDTO instanceInfoDTO = new InstanceInfoDTO();
        BeanUtils.copyProperties((Object)instanceInfoDO, (Object)instanceInfoDTO);
        return instanceInfoDTO;
    }

    public InstanceService(TransportService transportService, DispatchService dispatchService, IdGenerateService idGenerateService, InstanceManager instanceManager, JobInfoRepository jobInfoRepository, InstanceInfoRepository instanceInfoRepository, WorkerClusterQueryService workerClusterQueryService) {
        this.transportService = transportService;
        this.dispatchService = dispatchService;
        this.idGenerateService = idGenerateService;
        this.instanceManager = instanceManager;
        this.jobInfoRepository = jobInfoRepository;
        this.instanceInfoRepository = instanceInfoRepository;
        this.workerClusterQueryService = workerClusterQueryService;
    }
}

