/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.service.impl.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tech.powerjob.common.PowerQuery;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.enums.SwitchableStatus;
import tech.powerjob.common.enums.TimeExpressionType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.AlarmConfig;
import tech.powerjob.common.model.LifeCycle;
import tech.powerjob.common.request.http.SaveJobInfoRequest;
import tech.powerjob.common.response.JobInfoDTO;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.server.common.SJ;
import tech.powerjob.server.common.timewheel.holder.InstanceTimeWheelService;
import tech.powerjob.server.core.DispatchService;
import tech.powerjob.server.core.instance.InstanceService;
import tech.powerjob.server.core.scheduler.TimingStrategyService;
import tech.powerjob.server.core.service.JobService;
import tech.powerjob.server.core.service.impl.job.JobConverter;
import tech.powerjob.server.persistence.QueryConvertUtils;
import tech.powerjob.server.persistence.remote.model.InstanceInfoDO;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.repository.InstanceInfoRepository;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;
import tech.powerjob.server.remote.server.redirector.DesignateServer;

@Service
public class JobServiceImpl
implements JobService {
    private static final Logger log = LoggerFactory.getLogger(JobServiceImpl.class);
    private final InstanceService instanceService;
    private final DispatchService dispatchService;
    private final JobInfoRepository jobInfoRepository;
    private final InstanceInfoRepository instanceInfoRepository;
    private final TimingStrategyService timingStrategyService;

    @Override
    public Long saveJob(SaveJobInfoRequest request) {
        request.valid();
        JobInfoDO jobInfoDO = request.getId() != null ? (JobInfoDO)this.jobInfoRepository.findById((Object)request.getId()).orElseThrow(() -> new IllegalArgumentException("can't find job by jobId: " + request.getId())) : new JobInfoDO();
        BeanUtils.copyProperties((Object)request, (Object)jobInfoDO);
        jobInfoDO.setExecuteType(Integer.valueOf(request.getExecuteType().getV()));
        jobInfoDO.setProcessorType(Integer.valueOf(request.getProcessorType().getV()));
        jobInfoDO.setTimeExpressionType(Integer.valueOf(request.getTimeExpressionType().getV()));
        jobInfoDO.setStatus(Integer.valueOf(request.isEnable() ? SwitchableStatus.ENABLE.getV() : SwitchableStatus.DISABLE.getV()));
        jobInfoDO.setDispatchStrategy(Integer.valueOf(request.getDispatchStrategy().getV()));
        this.fillDefaultValue(jobInfoDO);
        if (request.getNotifyUserIds() != null) {
            if (request.getNotifyUserIds().size() == 0) {
                jobInfoDO.setNotifyUserIds(null);
            } else {
                jobInfoDO.setNotifyUserIds(SJ.COMMA_JOINER.join((Iterable)request.getNotifyUserIds()));
            }
        }
        LifeCycle lifecycle = Optional.ofNullable(request.getLifeCycle()).orElse(LifeCycle.EMPTY_LIFE_CYCLE);
        jobInfoDO.setLifecycle(JSON.toJSONString((Object)lifecycle));
        this.timingStrategyService.validate(request.getTimeExpressionType(), request.getTimeExpression(), lifecycle.getStart(), lifecycle.getEnd());
        this.calculateNextTriggerTime(jobInfoDO);
        if (request.getId() == null) {
            jobInfoDO.setGmtCreate(new Date());
        }
        if (request.getAlarmConfig() != null) {
            AlarmConfig config = request.getAlarmConfig();
            if (config.getStatisticWindowLen() == null || config.getAlertThreshold() == null || config.getSilenceWindowLen() == null) {
                throw new PowerJobException("illegal alarm config!");
            }
            jobInfoDO.setAlarmConfig(JSON.toJSONString((Object)request.getAlarmConfig()));
        }
        if (request.getLogConfig() != null) {
            jobInfoDO.setLogConfig(JSONObject.toJSONString((Object)request.getLogConfig()));
        }
        if (request.getAdvancedRuntimeConfig() != null) {
            jobInfoDO.setAdvancedRuntimeConfig(JSONObject.toJSONString((Object)request.getAdvancedRuntimeConfig()));
        }
        JobInfoDO res = (JobInfoDO)this.jobInfoRepository.saveAndFlush((Object)jobInfoDO);
        return res.getId();
    }

    @Override
    public JobInfoDO copyJob(Long jobId) {
        JobInfoDO origin = (JobInfoDO)this.jobInfoRepository.findById((Object)jobId).orElseThrow(() -> new IllegalArgumentException("can't find job by jobId: " + jobId));
        if (origin.getStatus().intValue() == SwitchableStatus.DELETED.getV()) {
            throw new IllegalStateException("can't copy the job which has been deleted!");
        }
        JobInfoDO copyJob = new JobInfoDO();
        BeanUtils.copyProperties((Object)origin, (Object)copyJob);
        this.fillDefaultValue(copyJob);
        copyJob.setId(null);
        copyJob.setJobName(copyJob.getJobName() + "_COPY");
        copyJob.setGmtCreate(new Date());
        copyJob.setGmtModified(new Date());
        copyJob = (JobInfoDO)this.jobInfoRepository.saveAndFlush((Object)copyJob);
        return copyJob;
    }

    @Override
    public JobInfoDTO fetchJob(Long jobId) {
        return JobConverter.convertJobInfoDO2JobInfoDTO((JobInfoDO)this.jobInfoRepository.findById((Object)jobId).orElseThrow(() -> new IllegalArgumentException("can't find job by jobId: " + jobId)));
    }

    @Override
    public List<JobInfoDTO> fetchAllJob(Long appId) {
        return this.jobInfoRepository.findByAppId(appId).stream().map(JobConverter::convertJobInfoDO2JobInfoDTO).collect(Collectors.toList());
    }

    @Override
    public List<JobInfoDTO> queryJob(PowerQuery powerQuery) {
        Specification specification = QueryConvertUtils.toSpecification((PowerQuery)powerQuery);
        return this.jobInfoRepository.findAll(specification).stream().map(JobConverter::convertJobInfoDO2JobInfoDTO).collect(Collectors.toList());
    }

    @Override
    @DesignateServer
    public long runJob(Long appId, Long jobId, String instanceParams, Long delay) {
        delay = delay == null ? 0L : delay;
        JobInfoDO jobInfo = (JobInfoDO)this.jobInfoRepository.findById((Object)jobId).orElseThrow(() -> new IllegalArgumentException("can't find job by id:" + jobId));
        log.info("[Job-{}] try to run job in app[{}], instanceParams={},delay={} ms.", new Object[]{jobInfo.getId(), appId, instanceParams, delay});
        InstanceInfoDO instanceInfo = this.instanceService.create(jobInfo.getId(), jobInfo.getAppId(), jobInfo.getJobParams(), instanceParams, null, System.currentTimeMillis() + Math.max(delay, 0L));
        this.instanceInfoRepository.flush();
        if (delay <= 0L) {
            this.dispatchService.dispatch(jobInfo, instanceInfo.getInstanceId(), Optional.of(instanceInfo), Optional.empty());
        } else {
            InstanceTimeWheelService.schedule((Long)instanceInfo.getInstanceId(), (Long)delay, () -> this.dispatchService.dispatch(jobInfo, instanceInfo.getInstanceId(), Optional.empty(), Optional.empty()));
        }
        log.info("[Job-{}|{}] execute 'runJob' successfully, params={}", new Object[]{jobInfo.getId(), instanceInfo.getInstanceId(), instanceParams});
        return instanceInfo.getInstanceId();
    }

    @Override
    public void deleteJob(Long jobId) {
        this.shutdownOrStopJob(jobId, SwitchableStatus.DELETED);
    }

    @Override
    public void disableJob(Long jobId) {
        this.shutdownOrStopJob(jobId, SwitchableStatus.DISABLE);
    }

    @Override
    public SaveJobInfoRequest exportJob(Long jobId) {
        Optional jobInfoOpt = this.jobInfoRepository.findById((Object)jobId);
        if (!jobInfoOpt.isPresent()) {
            throw new IllegalArgumentException("can't find job by jobId: " + jobId);
        }
        JobInfoDO jobInfoDO = (JobInfoDO)jobInfoOpt.get();
        SaveJobInfoRequest saveJobInfoRequest = JobConverter.convertJobInfoDO2SaveJobInfoRequest(jobInfoDO);
        saveJobInfoRequest.setId(null);
        saveJobInfoRequest.setJobName(saveJobInfoRequest.getJobName() + "_EXPORT_" + System.currentTimeMillis());
        log.info("[Job-{}] [exportJob] jobInfoDO: {}, saveJobInfoRequest: {}", new Object[]{jobId, JsonUtils.toJSONString((Object)jobInfoDO), JsonUtils.toJSONString((Object)saveJobInfoRequest)});
        return saveJobInfoRequest;
    }

    @Override
    public void enableJob(Long jobId) {
        JobInfoDO jobInfoDO = (JobInfoDO)this.jobInfoRepository.findById((Object)jobId).orElseThrow(() -> new IllegalArgumentException("can't find job by jobId:" + jobId));
        jobInfoDO.setStatus(Integer.valueOf(SwitchableStatus.ENABLE.getV()));
        this.calculateNextTriggerTime(jobInfoDO);
        this.jobInfoRepository.saveAndFlush((Object)jobInfoDO);
    }

    private void shutdownOrStopJob(Long jobId, SwitchableStatus status) {
        Optional jobInfoOPT = this.jobInfoRepository.findById((Object)jobId);
        if (!jobInfoOPT.isPresent()) {
            throw new IllegalArgumentException("can't find job by jobId:" + jobId);
        }
        JobInfoDO jobInfoDO = (JobInfoDO)jobInfoOPT.get();
        jobInfoDO.setStatus(Integer.valueOf(status.getV()));
        jobInfoDO.setGmtModified(new Date());
        this.jobInfoRepository.saveAndFlush((Object)jobInfoDO);
        if (!TimeExpressionType.FREQUENT_TYPES.contains(jobInfoDO.getTimeExpressionType())) {
            return;
        }
        List executeLogs = this.instanceInfoRepository.findByJobIdAndStatusIn(jobId.longValue(), InstanceStatus.GENERALIZED_RUNNING_STATUS);
        if (CollectionUtils.isEmpty((Collection)executeLogs)) {
            return;
        }
        if (executeLogs.size() > 1) {
            log.warn("[Job-{}] frequent job should just have one running instance, there must have some bug.", (Object)jobId);
        }
        executeLogs.forEach(instance -> {
            try {
                this.instanceService.stopInstance(instance.getAppId(), instance.getInstanceId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void calculateNextTriggerTime(JobInfoDO jobInfo) {
        if (TimeExpressionType.FREQUENT_TYPES.contains(jobInfo.getTimeExpressionType())) {
            jobInfo.setNextTriggerTime(null);
        } else {
            LifeCycle lifeCycle = LifeCycle.parse((String)jobInfo.getLifecycle());
            Long nextValidTime = this.timingStrategyService.calculateNextTriggerTimeWithInspection(TimeExpressionType.of((int)jobInfo.getTimeExpressionType()), jobInfo.getTimeExpression(), lifeCycle.getStart(), lifeCycle.getEnd());
            jobInfo.setNextTriggerTime(nextValidTime);
        }
        jobInfo.setGmtModified(new Date());
    }

    private void fillDefaultValue(JobInfoDO jobInfoDO) {
        if (jobInfoDO.getMaxWorkerCount() == null) {
            jobInfoDO.setMaxWorkerCount(Integer.valueOf(0));
        }
        if (jobInfoDO.getMaxInstanceNum() == null) {
            jobInfoDO.setMaxInstanceNum(Integer.valueOf(0));
        }
        if (jobInfoDO.getConcurrency() == null) {
            jobInfoDO.setConcurrency(Integer.valueOf(5));
        }
        if (jobInfoDO.getInstanceRetryNum() == null) {
            jobInfoDO.setInstanceRetryNum(Integer.valueOf(0));
        }
        if (jobInfoDO.getTaskRetryNum() == null) {
            jobInfoDO.setTaskRetryNum(Integer.valueOf(0));
        }
        if (jobInfoDO.getInstanceTimeLimit() == null) {
            jobInfoDO.setInstanceTimeLimit(Long.valueOf(0L));
        }
    }

    public JobServiceImpl(InstanceService instanceService, DispatchService dispatchService, JobInfoRepository jobInfoRepository, InstanceInfoRepository instanceInfoRepository, TimingStrategyService timingStrategyService) {
        this.instanceService = instanceService;
        this.dispatchService = dispatchService;
        this.jobInfoRepository = jobInfoRepository;
        this.instanceInfoRepository = instanceInfoRepository;
        this.timingStrategyService = timingStrategyService;
    }
}

